/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={})
@XmlRootElement(name="beans")
public class Beans {
    private static final URL DEFAULT_URL = null;
    @XmlTransient
    protected List<String> duplicatedInterceptors;
    @XmlTransient
    protected List<String> duplicatedDecorators;
    @XmlTransient
    protected List<String> startupBeans;
    @XmlTransient
    protected Alternatives duplicatedAlternatives;
    @XmlTransient
    private final Map<URL, List<String>> managedClasses = new HashMap<URL, List<String>>();
    @XmlTransient
    private final Map<URL, List<String>> notManagedClasses = new HashMap<URL, List<String>>();
    @XmlElementWrapper(name="interceptors")
    @XmlElement(name="class")
    protected List<String> interceptors;
    @XmlElementWrapper(name="decorators")
    @XmlElement(name="class")
    protected List<String> decorators;
    protected Alternatives alternatives;
    @XmlElement(name="trim")
    protected String trim;
    @XmlAttribute(name="version")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String version;
    @XmlAttribute(name="bean-discovery-mode", required=true)
    protected String beanDiscoveryMode;
    @XmlElement
    protected Scan scan;
    @XmlTransient
    private String uri;

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Scan getScan() {
        if (this.scan == null) {
            this.scan = new Scan();
        }
        return this.scan;
    }

    public void setScan(Scan scan) {
        this.scan = scan;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBeanDiscoveryMode() {
        return this.beanDiscoveryMode;
    }

    public void setBeanDiscoveryMode(String beanDiscoveryMode) {
        this.beanDiscoveryMode = beanDiscoveryMode;
    }

    public Beans managedClass(String clazz) {
        this.addManagedClass(null, clazz);
        return this;
    }

    public void addManagedClass(URL url, String clazz) {
        List list = this.managedClasses.computeIfAbsent(url, k -> new LinkedList());
        list.add(clazz);
    }

    public Map<URL, List<String>> getManagedClasses() {
        return this.managedClasses;
    }

    public Map<URL, List<String>> getNotManagedClasses() {
        return this.notManagedClasses;
    }

    @Deprecated
    public void addManagedClass(String className) {
        this.addManagedClass(DEFAULT_URL, className);
    }

    @Deprecated
    public void addManagedClass(Class clazz) {
        this.addManagedClass(clazz.getName());
    }

    public List<String> getInterceptors() {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<String>();
        }
        return this.interceptors;
    }

    public void addInterceptor(String className) {
        this.getInterceptors().add(className);
    }

    public void addInterceptor(Class clazz) {
        this.addInterceptor(clazz.getName());
    }

    public List<String> getDecorators() {
        if (this.decorators == null) {
            this.decorators = new ArrayList<String>();
        }
        return this.decorators;
    }

    public void addDecorator(String className) {
        this.getDecorators().add(className);
    }

    public void addDecorator(Class clazz) {
        this.addDecorator(clazz.getName());
    }

    public List<String> getAlternativeClasses() {
        return this.getAlternatives().getClasses();
    }

    public void addAlternativeClass(String className) {
        this.getAlternativeClasses().add(className);
    }

    public void addAlternativeClass(Class clazz) {
        this.addAlternativeClass(clazz.getName());
    }

    public List<String> getAlternativeStereotypes() {
        return this.getAlternatives().getStereotypes();
    }

    public void addAlternativeStereotype(String className) {
        this.getAlternativeStereotypes().add(className);
    }

    public void addAlternativeStereotype(Class clazz) {
        this.addAlternativeStereotype(clazz.getName());
    }

    private Alternatives getAlternatives() {
        if (this.alternatives == null) {
            this.alternatives = new Alternatives();
        }
        return this.alternatives;
    }

    public String getTrim() {
        return this.trim;
    }

    public void setTrim(String trim) {
        this.trim = trim;
    }

    public boolean isTrim() {
        return this.trim != null;
    }

    public List<String> getDuplicatedInterceptors() {
        if (this.duplicatedInterceptors == null) {
            this.duplicatedInterceptors = new ArrayList<String>();
        }
        return this.duplicatedInterceptors;
    }

    public List<String> getDuplicatedDecorators() {
        if (this.duplicatedDecorators == null) {
            this.duplicatedDecorators = new ArrayList<String>();
        }
        return this.duplicatedDecorators;
    }

    public Alternatives getDuplicatedAlternatives() {
        if (this.duplicatedAlternatives == null) {
            this.duplicatedAlternatives = new Alternatives();
        }
        return this.duplicatedAlternatives;
    }

    public List<String> getStartupBeans() {
        if (this.startupBeans == null) {
            this.startupBeans = new LinkedList<String>();
        }
        return this.startupBeans;
    }

    public void removeDuplicates() {
        this.removeDuplicates(this.getAlternativeClasses());
        this.removeDuplicates(this.getAlternativeStereotypes());
        this.removeDuplicates(this.getDecorators());
        this.removeDuplicates(this.getInterceptors());
    }

    private <T> void removeDuplicates(List<T> list) {
        ArrayList<T> classes = new ArrayList<T>();
        for (T t : list) {
            if (classes.contains(t)) continue;
            classes.add(t);
        }
        list.clear();
        list.addAll(classes);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlRootElement(name="scan")
    public static class Scan {
        protected List<Exclude> exclude;

        public List<Exclude> getExclude() {
            if (this.exclude == null) {
                this.exclude = new ArrayList<Exclude>();
            }
            return this.exclude;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        public static class Exclude {
            @XmlElements(value={@XmlElement(name="if-class-available", type=IfAvailableClassCondition.class), @XmlElement(name="if-class-not-available", type=IfNotAvailableClassCondition.class), @XmlElement(name="if-system-property", type=IfSystemProperty.class)})
            protected List<Object> ifClassAvailableOrIfClassNotAvailableOrIfSystemProperty;
            @XmlAttribute(name="name", required=true)
            protected String name;

            public List<Object> getIfClassAvailableOrIfClassNotAvailableOrIfSystemProperty() {
                if (this.ifClassAvailableOrIfClassNotAvailableOrIfSystemProperty == null) {
                    this.ifClassAvailableOrIfClassNotAvailableOrIfSystemProperty = new ArrayList<Object>();
                }
                return this.ifClassAvailableOrIfClassNotAvailableOrIfSystemProperty;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String value) {
                this.name = value;
            }

            @XmlAccessorType(value=XmlAccessType.FIELD)
            public static class IfSystemProperty {
                @XmlAttribute(name="name", required=true)
                protected String name;
                @XmlAttribute(name="value")
                protected String value;

                public String getName() {
                    return this.name;
                }

                public void setName(String value) {
                    this.name = value;
                }

                public String getValue() {
                    return this.value;
                }

                public void setValue(String value) {
                    this.value = value;
                }
            }

            @XmlAccessorType(value=XmlAccessType.FIELD)
            public static class ClassCondition {
                @XmlAttribute(name="name", required=true)
                protected String name;

                public String getName() {
                    return this.name;
                }

                public void setName(String value) {
                    this.name = value;
                }
            }

            public static class IfNotAvailableClassCondition
            extends ClassCondition {
            }

            public static class IfAvailableClassCondition
            extends ClassCondition {
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"classes", "stereotypes"})
    @XmlRootElement(name="alternatives")
    public static class Alternatives {
        @XmlElement(name="class")
        protected List<String> classes;
        @XmlElement(name="stereotype")
        protected List<String> stereotypes;

        public List<String> getClasses() {
            if (this.classes == null) {
                this.classes = new ArrayList<String>();
            }
            return this.classes;
        }

        public List<String> getStereotypes() {
            if (this.stereotypes == null) {
                this.stereotypes = new ArrayList<String>();
            }
            return this.stereotypes;
        }
    }
}

