/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.openejb.monitoring.Event;
import org.apache.openejb.monitoring.Managed;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServerServiceFilter;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.auth.ExactIPAddressPermission;
import org.apache.openejb.server.auth.ExactIPv6AddressPermission;
import org.apache.openejb.server.auth.IPAddressPermission;
import org.apache.openejb.server.auth.IPAddressPermissionFactory;
import org.apache.openejb.server.auth.PermitAllPermission;

@Managed
public class ServiceAccessController
extends ServerServiceFilter {
    private final Event rejections = new Event();
    private IPAddressPermission[] hostPermissions;
    @Managed
    private final Access access = new Access();

    public ServiceAccessController(ServerService next) {
        super(next);
    }

    @Override
    public void service(Socket socket) throws ServiceException, IOException {
        this.checkHostsAuthorization(socket.getInetAddress(), socket.getLocalAddress());
        super.service(socket);
    }

    @Override
    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException("service(in,out)");
    }

    public void checkHostsAuthorization(InetAddress clientAddress, InetAddress serverAddress) throws SecurityException {
        if (clientAddress.equals(serverAddress)) {
            return;
        }
        for (IPAddressPermission host : this.hostPermissions) {
            if (!host.implies(clientAddress)) continue;
            return;
        }
        this.rejections.record();
        throw new SecurityException("Host " + clientAddress.getHostAddress() + " is not authorized to access this service.");
    }

    private void parseAdminIPs(Properties props) throws ServiceException {
        LinkedList<IPAddressPermission> permissions = new LinkedList<IPAddressPermission>();
        String ipString = props.getProperty("only_from");
        if (ipString == null) {
            permissions.add(new PermitAllPermission());
        } else {
            String hostname = "localhost";
            this.addIPAddressPermissions(permissions, "localhost");
            StringTokenizer st = new StringTokenizer(ipString, ", \n\t");
            while (st.hasMoreTokens()) {
                String mask = st.nextToken();
                try {
                    permissions.add(IPAddressPermissionFactory.getIPAddressMask(mask));
                }
                catch (IllegalArgumentException iae) {
                    this.addIPAddressPermissions(permissions, mask);
                }
            }
        }
        this.hostPermissions = permissions.toArray(new IPAddressPermission[permissions.size()]);
    }

    private void addIPAddressPermissions(LinkedList<IPAddressPermission> permissions, String hostname) throws ServiceException {
        try {
            InetAddress[] localIps;
            for (InetAddress localIp : localIps = InetAddress.getAllByName(hostname)) {
                if (localIp instanceof Inet4Address) {
                    permissions.add(new ExactIPAddressPermission(localIp.getAddress()));
                    continue;
                }
                permissions.add(new ExactIPv6AddressPermission(localIp.getAddress()));
            }
        }
        catch (UnknownHostException e) {
            throw new ServiceException("Could not get " + hostname + " inet address", e);
        }
    }

    @Override
    public void init(Properties props) throws Exception {
        this.parseAdminIPs(props);
        super.init(props);
    }

    @Managed(append=true)
    public class Access {
        @Managed
        public List<String> getHostPermissions() {
            ArrayList<String> list = new ArrayList<String>();
            for (IPAddressPermission hostPermission : ServiceAccessController.this.hostPermissions) {
                list.add(hostPermission.toString());
            }
            return list;
        }

        @Managed
        public Event getRejections() {
            return ServiceAccessController.this.rejections;
        }
    }
}

