/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.sodium;

import java.util.Objects;
import javax.security.auth.Destroyable;
import jnr.ffi.Pointer;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.sodium.Allocated;
import org.apache.tuweni.crypto.sodium.Sodium;

public final class GenericHash {
    public static Hash hash(int hashLength, Input input) {
        Pointer output = Sodium.malloc(hashLength);
        Sodium.crypto_generichash(output, hashLength, input.value.pointer(), input.length(), null, 0L);
        return new Hash(output, hashLength);
    }

    public static Hash hash(int hashLength, Input input, Key key) {
        Pointer output = Sodium.malloc(hashLength);
        Sodium.crypto_generichash(output, hashLength, input.value.pointer(), input.length(), key.value.pointer(), key.length());
        return new Hash(output, hashLength);
    }

    public static final class Hash
    implements Destroyable {
        Allocated value;

        Hash(Pointer ptr, int length) {
            this.value = new Allocated(ptr, length);
        }

        @Override
        public void destroy() {
            this.value.destroy();
        }

        @Override
        public boolean isDestroyed() {
            return this.value.isDestroyed();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Hash)) {
                return false;
            }
            Hash other = (Hash)obj;
            return other.value.equals(this.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public Bytes bytes() {
            return this.value.bytes();
        }

        public byte[] bytesArray() {
            return this.value.bytesArray();
        }

        public int length() {
            return this.value.length();
        }
    }

    public static final class Key
    implements Destroyable {
        private final Allocated value;

        private Key(Pointer ptr, int length) {
            this.value = new Allocated(ptr, length);
        }

        @Override
        public void destroy() {
            this.value.destroy();
        }

        @Override
        public boolean isDestroyed() {
            return this.value.isDestroyed();
        }

        public int length() {
            return this.value.length();
        }

        public static Key fromPointer(Allocated allocated) {
            return new Key(Sodium.dup(allocated.pointer(), allocated.length()), allocated.length());
        }

        public static Key fromHash(Hash hash) {
            return new Key(Sodium.dup(hash.value.pointer(), hash.value.length()), hash.value.length());
        }

        public static Key fromBytes(Bytes bytes) {
            return Key.fromBytes(bytes.toArrayUnsafe());
        }

        public static Key fromBytes(byte[] bytes) {
            return Sodium.dup(bytes, Key::new);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return other.value.equals(this.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public Bytes bytes() {
            return this.value.bytes();
        }

        public byte[] bytesArray() {
            return this.value.bytesArray();
        }
    }

    public static final class Input
    implements Destroyable {
        private final Allocated value;

        private Input(Pointer ptr, int length) {
            this.value = new Allocated(ptr, length);
        }

        @Override
        public void destroy() {
            this.value.destroy();
        }

        @Override
        public boolean isDestroyed() {
            return this.value.isDestroyed();
        }

        public int length() {
            return this.value.length();
        }

        public static Input fromPointer(Allocated allocated) {
            return new Input(Sodium.dup(allocated.pointer(), allocated.length()), allocated.length());
        }

        public static Input fromHash(Hash hash) {
            return new Input(Sodium.dup(hash.value.pointer(), hash.value.length()), hash.value.length());
        }

        public static Input fromBytes(Bytes bytes) {
            return Input.fromBytes(bytes.toArrayUnsafe());
        }

        public static Input fromBytes(byte[] bytes) {
            return Sodium.dup(bytes, Input::new);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Input)) {
                return false;
            }
            Input other = (Input)obj;
            return other.value.equals(this.value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public Bytes bytes() {
            return this.value.bytes();
        }

        public byte[] bytesArray() {
            return this.value.bytesArray();
        }
    }
}

