/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5;

import com.google.common.math.IntMath;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.devp2p.EthereumNodeRecord;
import org.apache.tuweni.kademlia.KademliaRoutingTable;
import org.apache.tuweni.kademlia.KademliaRoutingTableKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0007J\u0006\u0010\u0019\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0018J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\fJ\u0006\u0010\u001f\u001a\u00020\u0007R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/apache/tuweni/devp2p/v5/RoutingTable;", "", "selfEnr", "Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "(Lorg/apache/tuweni/devp2p/EthereumNodeRecord;)V", "nodeIdCalculation", "Lkotlin/Function1;", "Lorg/apache/tuweni/bytes/Bytes;", "", "selfNodeId", "kotlin.jvm.PlatformType", "size", "", "getSize", "()I", "table", "Lorg/apache/tuweni/kademlia/KademliaRoutingTable;", "add", "", "enr", "clear", "distanceToSelf", "targetId", "evict", "", "getSelfEnr", "isEmpty", "key", "nodesOfDistance", "", "distance", "random", "Companion", "devp2p"})
public final class RoutingTable {
    private final byte[] selfNodeId;
    private final Function1<Bytes, byte[]> nodeIdCalculation;
    private final KademliaRoutingTable<Bytes> table;
    private final EthereumNodeRecord selfEnr;
    private static final int BUCKET_SIZE = 16;
    public static final Companion Companion = new Companion(null);

    public final int getSize() {
        return this.table.size();
    }

    @NotNull
    public final EthereumNodeRecord getSelfEnr() {
        return this.selfEnr;
    }

    public final void add(@NotNull EthereumNodeRecord enr2) {
        Intrinsics.checkParameterIsNotNull((Object)enr2, (String)"enr");
        this.add(enr2.toRLP());
    }

    public final void add(@NotNull Bytes enr2) {
        Intrinsics.checkParameterIsNotNull((Object)enr2, (String)"enr");
        if (Intrinsics.areEqual((Object)enr2, (Object)this.selfEnr.toRLP()) ^ true) {
            this.table.add((Object)enr2);
        }
    }

    public final int distanceToSelf(@NotNull Bytes targetId) {
        Intrinsics.checkParameterIsNotNull((Object)targetId, (String)"targetId");
        return this.table.logDistToSelf((Object)targetId);
    }

    public final boolean evict(@NotNull Bytes enr2) {
        Intrinsics.checkParameterIsNotNull((Object)enr2, (String)"enr");
        return this.table.evict((Object)enr2);
    }

    @NotNull
    public final Bytes random() {
        return (Bytes)this.table.getRandom();
    }

    public final boolean isEmpty() {
        return this.table.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<EthereumNodeRecord> nodesOfDistance(int distance) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.table.peersOfDistance(distance);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Bytes bytes = (Bytes)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            EthereumNodeRecord ethereumNodeRecord = EthereumNodeRecord.Companion.fromRLP((Bytes)it);
            collection.add(ethereumNodeRecord);
        }
        return (List)destination$iv$iv;
    }

    public final void clear() {
        this.table.clear();
    }

    private final byte[] key(Bytes enr2) {
        byte[] byArray = EthereumNodeRecord.Companion.fromRLP(enr2).nodeId().toArrayUnsafe();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"EthereumNodeRecord.fromR\u2026.nodeId().toArrayUnsafe()");
        return byArray;
    }

    public RoutingTable(@NotNull EthereumNodeRecord selfEnr) {
        Intrinsics.checkParameterIsNotNull((Object)selfEnr, (String)"selfEnr");
        this.selfEnr = selfEnr;
        this.selfNodeId = EthereumNodeRecord.Companion.nodeId(this.selfEnr.publicKey()).toArrayUnsafe();
        this.nodeIdCalculation = (Function1)new Function1<Bytes, byte[]>(this){
            final /* synthetic */ RoutingTable this$0;

            @NotNull
            public final byte[] invoke(@NotNull Bytes enr2) {
                Intrinsics.checkParameterIsNotNull((Object)enr2, (String)"enr");
                return RoutingTable.access$key(this.this$0, enr2);
            }
            {
                this.this$0 = routingTable;
                super(1);
            }
        };
        Intrinsics.checkExpressionValueIsNotNull((Object)this.selfNodeId, (String)"selfNodeId");
        this.table = new KademliaRoutingTable(this.selfNodeId, 16, 0, this.nodeIdCalculation, (Function1)new Function1<Bytes, Integer>(this){
            final /* synthetic */ RoutingTable this$0;

            public final int invoke(@NotNull Bytes it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                byte[] byArray = RoutingTable.access$key(this.this$0, it);
                byte[] byArray2 = RoutingTable.access$getSelfNodeId$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"selfNodeId");
                int xorResult = KademliaRoutingTableKt.xorDist((byte[])byArray, (byte[])byArray2);
                return xorResult == 0 ? 0 : IntMath.log2((int)xorResult, (RoundingMode)RoundingMode.FLOOR);
            }
            {
                this.this$0 = routingTable;
                super(1);
            }
        }, 4, null);
    }

    public static final /* synthetic */ byte[] access$key(RoutingTable $this, Bytes enr2) {
        return $this.key(enr2);
    }

    public static final /* synthetic */ byte[] access$getSelfNodeId$p(RoutingTable $this) {
        return $this.selfNodeId;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/apache/tuweni/devp2p/v5/RoutingTable$Companion;", "", "()V", "BUCKET_SIZE", "", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

