/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.discovery;

import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.discovery.DNSEntry;
import org.apache.tuweni.io.Base32;
import org.bouncycastle.math.ec.ECPoint;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/apache/tuweni/discovery/ENRTreeLink;", "Lorg/apache/tuweni/discovery/DNSEntry;", "url", "", "(Ljava/lang/String;)V", "domainName", "getDomainName", "()Ljava/lang/String;", "pubKey", "getPubKey", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "toString", "dns-discovery"})
public final class ENRTreeLink
implements DNSEntry {
    @NotNull
    private final String domainName;
    @NotNull
    private final String pubKey;

    @NotNull
    public final String getDomainName() {
        return this.domainName;
    }

    @NotNull
    public final String getPubKey() {
        return this.pubKey;
    }

    @NotNull
    public final SECP256K1.PublicKey publicKey() {
        byte[] keyBytes = Base32.decodeBytes((String)this.pubKey);
        ECPoint ecPoint = SECP256K1.Parameters.CURVE.getCurve().decodePoint(keyBytes);
        SECP256K1.PublicKey publicKey = SECP256K1.PublicKey.fromBytes((Bytes)Bytes.wrap((byte[])ecPoint.getEncoded(false)).slice(1));
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"SECP256K1.PublicKey.from\u2026Encoded(false)).slice(1))");
        return publicKey;
    }

    @NotNull
    public String toString() {
        return "enrtree://" + this.pubKey + '@' + this.domainName;
    }

    public ENRTreeLink(@NotNull String url) {
        URI uri;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        URI uRI = uri = URI.create(url);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"uri");
        String string = uRI.getHost();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri.host");
        this.domainName = string;
        String string2 = uri.getUserInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"uri.userInfo");
        this.pubKey = string2;
    }
}

