/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.io;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;

public final class Base32 {
    private static final org.apache.commons.codec.binary.Base32 codec = new org.apache.commons.codec.binary.Base32();

    private Base32() {
    }

    public static String encodeBytes(byte[] bytes) {
        Objects.requireNonNull(bytes);
        return new String(codec.encode(bytes), StandardCharsets.UTF_8);
    }

    public static String encode(Bytes bytes) {
        Objects.requireNonNull(bytes);
        return Base32.encodeBytes(bytes.toArrayUnsafe());
    }

    public static byte[] decodeBytes(String b32) {
        Objects.requireNonNull(b32);
        return codec.decode(b32.getBytes(StandardCharsets.UTF_8));
    }

    public static Bytes decode(String b32) {
        return Bytes.wrap((byte[])Base32.decodeBytes(b32));
    }
}

