/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt32;

public interface UInt32Value<T extends UInt32Value<T>>
extends Comparable<T> {
    default public boolean isZero() {
        return this.toBytes().isZero();
    }

    public T add(T var1);

    default public T addExact(T value) {
        T result = this.add(value);
        if (this.compareTo(result) > 0) {
            throw new ArithmeticException("UInt32 overflow");
        }
        return result;
    }

    public T add(int var1);

    default public T addExact(int value) {
        T result = this.add(value);
        if (value > 0 && this.compareTo(result) > 0 || value < 0 && this.compareTo(result) < 0) {
            throw new ArithmeticException("UInt32 overflow");
        }
        return result;
    }

    public T addMod(T var1, UInt32 var2);

    public T addMod(long var1, UInt32 var3);

    public T addMod(long var1, long var3);

    public T subtract(T var1);

    default public T subtractExact(T value) {
        T result = this.subtract(value);
        if (this.compareTo(result) < 0) {
            throw new ArithmeticException("UInt32 overflow");
        }
        return result;
    }

    public T subtract(int var1);

    default public T subtractExact(int value) {
        T result = this.subtract(value);
        if (value > 0 && this.compareTo(result) < 0 || value < 0 && this.compareTo(result) > 0) {
            throw new ArithmeticException("UInt32 overflow");
        }
        return result;
    }

    public T multiply(T var1);

    public T multiply(int var1);

    public T multiplyMod(T var1, UInt32 var2);

    public T multiplyMod(int var1, UInt32 var2);

    public T multiplyMod(int var1, int var2);

    public T divide(T var1);

    public T divide(int var1);

    public T pow(UInt32 var1);

    public T pow(long var1);

    public T mod(UInt32 var1);

    public T mod(int var1);

    default public boolean fitsInt() {
        return !UInt32.MAX_VALUE.equals(this);
    }

    default public int intValue() {
        return this.toBigInteger().intValueExact();
    }

    default public boolean fitsLong() {
        return true;
    }

    default public long toLong() {
        return this.toBigInteger().longValueExact();
    }

    default public BigInteger toBigInteger() {
        return this.toBytes().toUnsignedBigInteger();
    }

    default public String toHexString() {
        return this.toBytes().toHexString();
    }

    default public String toShortHexString() {
        return this.toBytes().toShortHexString();
    }

    public UInt32 toUInt32();

    public Bytes toBytes();

    public Bytes toMinimalBytes();

    default public int numberOfLeadingZeros() {
        return this.toBytes().numberOfLeadingZeros();
    }

    default public int bitLength() {
        return this.toBytes().bitLength();
    }
}

