/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.Writer;
import java.util.ArrayList;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.MacroParseException;
import org.apache.velocity.runtime.directive.Scope;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.util.StringUtils;

public class Break
extends Directive {
    private boolean scoped = false;

    @Override
    public String getName() {
        return "break";
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public boolean isScopeProvided() {
        return false;
    }

    @Override
    public void init(RuntimeServices runtimeServices, InternalContextAdapter internalContextAdapter, Node node) {
        super.init(runtimeServices, internalContextAdapter, node);
        this.scoped = node.jjtGetNumChildren() == 1;
    }

    @Override
    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) {
        if (!this.scoped) {
            throw new StopCommand();
        }
        Object object = node.jjtGetChild(0).value(internalContextAdapter);
        if (object instanceof Scope) {
            ((Scope)object).stop();
            throw new IllegalStateException("Scope.stop() failed to throw a StopCommand");
        }
        throw new VelocityException(node.jjtGetChild(0).literal() + " is not a valid " + Scope.class.getName() + " instance at " + StringUtils.formatFileString(this));
    }

    @Override
    public void checkArgs(ArrayList<Integer> arrayList, Token token, String string) throws ParseException {
        if (arrayList.size() > 1) {
            throw new MacroParseException("The #break directive takes only a single, optional Scope argument", string, token);
        }
    }
}

