/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.IWritableRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.flow.ResetResponseException;
import org.apache.wicket.request.handler.PageProvider;
import org.apache.wicket.request.handler.RenderPageRequestHandler;
import org.apache.wicket.request.http.handler.RedirectRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestartResponseAtInterceptPageException
extends ResetResponseException {
    private static final long serialVersionUID = 1L;
    static IRequestMapper MAPPER = new IRequestMapper(){

        public int getCompatibilityScore(Request request) {
            return this.matchedData(request) != null ? Integer.MAX_VALUE : 0;
        }

        public Url mapHandler(IRequestHandler requestHandler) {
            return null;
        }

        public IRequestHandler mapRequest(Request request) {
            InterceptData data = this.matchedData(request);
            if (data != null) {
                if (!data.postParameters.isEmpty() && request.getPostParameters() instanceof IWritableRequestParameters) {
                    IWritableRequestParameters parameters = (IWritableRequestParameters)request.getPostParameters();
                    parameters.reset();
                    for (String s : data.postParameters.keySet()) {
                        parameters.setParameterValues(s, (List)data.postParameters.get(s));
                    }
                }
                InterceptData.clear();
            }
            return null;
        }

        private InterceptData matchedData(Request request) {
            InterceptData data = InterceptData.get();
            if (data != null && data.originalUrl.equals((Object)request.getOriginalUrl())) {
                return data;
            }
            return null;
        }
    };

    public RestartResponseAtInterceptPageException(Page interceptPage) {
        super((IRequestHandler)new RenderPageRequestHandler(new PageProvider(interceptPage), RenderPageRequestHandler.RedirectPolicy.AUTO_REDIRECT));
        InterceptData.set();
    }

    public RestartResponseAtInterceptPageException(Class<? extends Page> interceptPageClass) {
        this(interceptPageClass, null);
    }

    public RestartResponseAtInterceptPageException(Class<? extends Page> interceptPageClass, PageParameters parameters) {
        super((IRequestHandler)new RenderPageRequestHandler(new PageProvider(interceptPageClass, parameters), RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT));
        InterceptData.set();
    }

    static boolean continueToOriginalDestination() {
        InterceptData data = InterceptData.get();
        if (data != null) {
            data.continueOk = true;
            String url = RequestCycle.get().getUrlRenderer().renderUrl(data.originalUrl);
            RequestCycle.get().replaceAllRequestHandlers((IRequestHandler)new RedirectRequestHandler(url));
            return true;
        }
        return false;
    }

    static void clearOriginalDestination() {
        InterceptData.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InterceptData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Url originalUrl;
        private Map<String, List<StringValue>> postParameters;
        private boolean continueOk;
        private static MetaDataKey<InterceptData> key = new MetaDataKey<InterceptData>(){
            private static final long serialVersionUID = 1L;
        };

        InterceptData() {
        }

        public Url getOriginalUrl() {
            return this.originalUrl;
        }

        public Map<String, List<StringValue>> getPostParameters() {
            return this.postParameters;
        }

        public static void set() {
            Session session = Session.get();
            session.bind();
            InterceptData data = new InterceptData();
            Request request = RequestCycle.get().getRequest();
            data.originalUrl = request.getOriginalUrl();
            Iterator itor = data.originalUrl.getQueryParameters().iterator();
            while (itor.hasNext()) {
                Url.QueryParameter parameter = (Url.QueryParameter)itor.next();
                String parameterName = parameter.getName();
                if (!"wicket-ajax".equals(parameterName) && !"wicket-ajax-baseurl".equals(parameterName) && !"random".equals(parameterName)) continue;
                itor.remove();
            }
            data.postParameters = new HashMap<String, List<StringValue>>();
            for (String s : request.getPostParameters().getParameterNames()) {
                if ("wicket-ajax".equals(s) || "wicket-ajax-baseurl".equals(s) || "random".equals(s)) continue;
                data.postParameters.put(s, new ArrayList(request.getPostParameters().getParameterValues(s)));
            }
            data.continueOk = false;
            session.setMetaData(key, data);
        }

        public static InterceptData get() {
            return Session.get().getMetaData(key);
        }

        public static void clear() {
            if (Session.exists()) {
                Session.get().setMetaData(key, null);
            }
        }
    }
}

