/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.border;

import java.io.IOException;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ContainerInfo;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupFactory;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.MarkupType;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.locator.IResourceStreamLocator;

public class BorderBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private transient MarkupStream markupStream;

    public void beforeRender(Component component) {
        MarkupStream stream = this.getMarkupStream(component);
        Response response = component.getResponse();
        stream.setCurrentIndex(0);
        boolean insideBorderMarkup = false;
        while (stream.hasMore()) {
            MarkupElement elem = stream.get();
            stream.next();
            if (elem instanceof WicketTag) {
                WicketTag wTag = (WicketTag)elem;
                if (!insideBorderMarkup) {
                    if (wTag.isBorderTag() && wTag.isOpen()) {
                        insideBorderMarkup = true;
                        continue;
                    }
                    throw new WicketRuntimeException("Unexpected tag encountered in markup of component border " + this.getClass().getName() + ". Tag: " + wTag.toString() + ", expected tag: <wicket:border>");
                }
                if (wTag.isBodyTag()) break;
                throw new WicketRuntimeException("Unexpected tag encountered in markup of component border " + this.getClass().getName() + ". Tag: " + wTag.toString() + ", expected tag: <wicket:body> or </wicket:body>");
            }
            if (!insideBorderMarkup) continue;
            response.write(elem.toCharSequence());
        }
        if (!stream.hasMore()) {
            throw new WicketRuntimeException("Markup for component border " + this.getClass().getName() + " ended prematurely, was expecting </wicket:border>");
        }
    }

    public void afterRender(Component component) {
        MarkupStream stream = this.getMarkupStream(component);
        Response response = component.getResponse();
        while (stream.hasMore()) {
            MarkupElement elem = stream.get();
            stream.next();
            if (elem instanceof WicketTag) {
                WicketTag wTag = (WicketTag)elem;
                if (wTag.isBorderTag() && wTag.isClose()) break;
                throw new WicketRuntimeException("Unexpected tag encountered in markup of component border " + this.getClass().getName() + ". Tag: " + wTag.toString() + ", expected tag: </wicket:border>");
            }
            response.write(elem.toCharSequence());
        }
    }

    private MarkupStream getMarkupStream(Component component) {
        if (this.markupStream == null) {
            this.markupStream = this.findMarkupStream(component);
        }
        return this.markupStream;
    }

    private MarkupStream findMarkupStream(Component owner) {
        MarkupType markupType = this.getMarkupType(owner);
        if (markupType == null) {
            return null;
        }
        IResourceStreamLocator locator = Application.get().getResourceSettings().getResourceStreamLocator();
        String style = owner.getStyle();
        String variation = owner.getVariation();
        Locale locale = owner.getLocale();
        MarkupResourceStream markupResourceStream = null;
        Class<?> containerClass = this.getClass();
        while (!containerClass.equals(BorderBehavior.class)) {
            String path = containerClass.getName().replace('.', '/');
            IResourceStream resourceStream = locator.locate(containerClass, path, style, variation, locale, markupType.getExtension(), false);
            if (resourceStream != null) {
                ContainerInfo ci = new ContainerInfo(containerClass, locale, style, variation, markupType);
                markupResourceStream = new MarkupResourceStream(resourceStream, ci, containerClass);
                break;
            }
            containerClass = containerClass.getSuperclass();
        }
        if (markupResourceStream == null) {
            throw new WicketRuntimeException("Could not find markup for component border `" + this.getClass().getName() + "`");
        }
        try {
            Markup markup = MarkupFactory.get().newMarkupParser(markupResourceStream).parse();
            MarkupStream markupStream = new MarkupStream(markup);
            return markupStream;
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Could not parse markup from markup resource stream: " + markupResourceStream.toString(), e);
        }
        finally {
            try {
                markupResourceStream.close();
            }
            catch (IOException e) {
                throw new WicketRuntimeException("Cannot close markup resource stream: " + markupResourceStream, e);
            }
        }
    }

    private MarkupType getMarkupType(Component component) {
        MarkupType markupType = component instanceof MarkupContainer ? ((MarkupContainer)component).getMarkupType() : component.getParent().getMarkupType();
        return markupType;
    }

    static {
        WicketTagIdentifier.registerWellKnownTagName("border");
        WicketTagIdentifier.registerWellKnownTagName("body");
    }
}

