/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WicketEventReference;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public abstract class AbstractCheckSelector
extends LabeledWebMarkupContainer
implements IHeaderContributor {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference JS = new PackageResourceReference(AbstractCheckSelector.class, "CheckSelector.js");

    public AbstractCheckSelector(String id) {
        super(id);
        this.setOutputMarkupId(true);
    }

    protected boolean wantAutomaticUpdate() {
        return true;
    }

    public void renderHead(IHeaderResponse response) {
        response.renderJavaScriptReference(WicketEventReference.INSTANCE);
        response.renderJavaScriptReference(JS);
        String findCheckboxes = ((Object)this.getFindCheckboxesFunction()).toString();
        response.renderOnLoadJavaScript("Wicket.CheckboxSelector.initializeSelector('" + this.getMarkupId() + "', " + findCheckboxes + ");");
        if (this.wantAutomaticUpdate()) {
            response.renderOnLoadJavaScript("Wicket.CheckboxSelector.attachUpdateHandlers('" + this.getMarkupId() + "', " + findCheckboxes + ");");
        }
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.isEnableAllowed() && this.isEnabledInHierarchy()) {
            tag.remove("disabled");
        } else {
            tag.put("disabled", "disabled");
        }
        this.checkComponentTag(tag, "input");
        this.checkComponentTagAttribute(tag, "type", "checkbox");
    }

    protected abstract CharSequence getFindCheckboxesFunction();
}

