/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.ILinkListener;
import org.apache.wicket.markup.html.link.IPageLink;
import org.apache.wicket.request.mapper.parameter.PageParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineFrame
extends WebMarkupContainer
implements ILinkListener {
    private static final long serialVersionUID = 1L;
    private final IPageLink pageLink;

    public <C extends Page> InlineFrame(String id, Class<C> c) {
        this(id, c, null);
    }

    public <C extends Page> InlineFrame(String id, final Class<C> c, final PageParameters params) {
        this(id, new IPageLink(){
            private static final long serialVersionUID = 1L;

            @Override
            public Page getPage() {
                if (params == null) {
                    return (Page)Session.get().getPageFactory().newPage(c);
                }
                return (Page)Session.get().getPageFactory().newPage(c, params);
            }

            @Override
            public Class<? extends Page> getPageIdentity() {
                return c;
            }
        });
        if (!Page.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c + " is not a subclass of Page");
        }
    }

    public InlineFrame(String id, final Page page) {
        this(id, new IPageLink(){
            private static final long serialVersionUID = 1L;

            @Override
            public Page getPage() {
                return page;
            }

            @Override
            public Class<? extends Page> getPageIdentity() {
                return page.getClass();
            }
        });
    }

    public InlineFrame(String id, IPageLink pageLink) {
        super(id);
        this.pageLink = pageLink;
    }

    protected CharSequence getURL() {
        return this.urlFor(ILinkListener.INTERFACE, new PageParameters());
    }

    @Override
    protected final void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "iframe");
        CharSequence url = this.getURL();
        tag.put("src", url);
        super.onComponentTag(tag);
    }

    @Override
    public final void onLinkClicked() {
        this.setResponsePage(this.pageLink.getPage());
    }

    @Override
    protected boolean getStatelessHint() {
        return false;
    }
}

