/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.repeater;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.wicket.markup.repeater.IItemFactory;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReuseIfModelsEqualStrategy
implements IItemReuseStrategy {
    private static final long serialVersionUID = 1L;
    private static IItemReuseStrategy instance = new ReuseIfModelsEqualStrategy();

    public static IItemReuseStrategy getInstance() {
        return instance;
    }

    @Override
    public <T> Iterator<Item<T>> getItems(final IItemFactory<T> factory, final Iterator<IModel<T>> newModels, Iterator<Item<T>> existingItems) {
        final HashMap modelToItem = Generics.newHashMap();
        while (existingItems.hasNext()) {
            Item<T> item = existingItems.next();
            modelToItem.put(item.getModel(), item);
        }
        return new Iterator<Item<T>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return newModels.hasNext();
            }

            @Override
            public Item<T> next() {
                Item item;
                IModel model = (IModel)newModels.next();
                Item oldItem = (Item)modelToItem.get(model);
                if (oldItem == null) {
                    item = factory.newItem(this.index, model);
                } else {
                    oldItem.setIndex(this.index);
                    item = oldItem;
                }
                ++this.index;
                return item;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

