/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.request.resource.CssPackageResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.JavaScriptPackageResource;
import org.apache.wicket.request.resource.PackageResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.locator.IResourceStreamLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageResourceReference
extends ResourceReference {
    private static final long serialVersionUID = 1L;
    private static final String CSS_EXTENSION = "css";
    private static final String JAVASCRIPT_EXTENSION = "js";
    private transient ConcurrentMap<ResourceReference.UrlAttributes, ResourceReference.UrlAttributes> urlAttributesCacheMap;

    public PackageResourceReference(ResourceReference.Key key) {
        super(key);
    }

    public PackageResourceReference(Class<?> scope, String name, Locale locale, String style, String variation) {
        super(scope, name, locale, style, variation);
    }

    public PackageResourceReference(Class<?> scope, String name) {
        super(scope, name);
    }

    public PackageResourceReference(String name) {
        super(name);
    }

    @Override
    public IResource getResource() {
        String extension = this.getExtension();
        if (CSS_EXTENSION.equals(extension)) {
            return new CssPackageResource(this.getScope(), this.getName(), this.getLocale(), this.getStyle(), this.getVariation());
        }
        if (JAVASCRIPT_EXTENSION.equals(extension)) {
            return new JavaScriptPackageResource(this.getScope(), this.getName(), this.getLocale(), this.getStyle(), this.getVariation());
        }
        return new PackageResource(this.getScope(), this.getName(), this.getLocale(), this.getStyle(), this.getVariation());
    }

    private ResourceReference.UrlAttributes getUrlAttributes(Locale locale, String style, String variation) {
        IResourceStreamLocator locator = Application.get().getResourceSettings().getResourceStreamLocator();
        String absolutePath = Packages.absolutePath(this.getScope(), (String)this.getName());
        IResourceStream stream = locator.locate(this.getScope(), absolutePath, style, variation, locale, null, false);
        if (stream == null) {
            return new ResourceReference.UrlAttributes(null, null, null);
        }
        return new ResourceReference.UrlAttributes(stream.getLocale(), stream.getStyle(), stream.getVariation());
    }

    private Locale getCurrentLocale() {
        return this.getLocale() != null ? this.getLocale() : Session.get().getLocale();
    }

    private String getCurrentStyle() {
        return this.getStyle() != null ? this.getStyle() : Session.get().getStyle();
    }

    @Override
    public ResourceReference.UrlAttributes getUrlAttributes() {
        ResourceReference.UrlAttributes tmpValue;
        ResourceReference.UrlAttributes value;
        Locale locale = this.getCurrentLocale();
        String style = this.getCurrentStyle();
        String variation = this.getVariation();
        ResourceReference.UrlAttributes key = new ResourceReference.UrlAttributes(locale, style, variation);
        if (this.urlAttributesCacheMap == null) {
            this.urlAttributesCacheMap = Generics.newConcurrentHashMap();
        }
        if ((value = (ResourceReference.UrlAttributes)this.urlAttributesCacheMap.get(key)) == null && (tmpValue = this.urlAttributesCacheMap.putIfAbsent(key, value = this.getUrlAttributes(locale, style, variation))) != null) {
            value = tmpValue;
        }
        return value;
    }
}

