/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.objects.checker;

import java.util.List;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.objects.checker.AbstractObjectChecker;
import org.apache.wicket.util.objects.checker.IObjectChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotDetachedModelChecker
extends AbstractObjectChecker {
    public NotDetachedModelChecker() {
    }

    public NotDetachedModelChecker(List<Class<?>> exclusions) {
        super(exclusions);
    }

    @Override
    public IObjectChecker.Result doCheck(Object obj) {
        LoadableDetachableModel model;
        IObjectChecker.Result result = IObjectChecker.Result.SUCCESS;
        if (obj instanceof LoadableDetachableModel && (model = (LoadableDetachableModel)obj).isAttached()) {
            result = new IObjectChecker.Result(IObjectChecker.Result.Status.FAILURE, "Not detached model found!");
        }
        return result;
    }
}

