/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.behavior;

import java.lang.reflect.Method;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IComponentAwareEventSink;
import org.apache.wicket.behavior.IBehaviorListener;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IComponentAwareHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Behavior
implements IClusterable,
IComponentAwareEventSink,
IComponentAwareHeaderContributor {
    private static final long serialVersionUID = 1L;

    public Behavior() {
        if (Application.exists()) {
            Application.get().getBehaviorInstantiationListeners().onInstantiation(this);
        }
    }

    public void beforeRender(Component component) {
    }

    public void afterRender(Component component) {
    }

    public void bind(Component component) {
    }

    public void unbind(Component component) {
    }

    public void detach(Component component) {
    }

    public void onException(Component component, RuntimeException exception) {
    }

    public boolean getStatelessHint(Component component) {
        return !(this instanceof IBehaviorListener);
    }

    public boolean isEnabled(Component component) {
        return true;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
    }

    public boolean isTemporary(Component component) {
        return false;
    }

    @Deprecated
    public boolean canCallListenerInterface(Component component) {
        return this.isEnabled(component) && component.canCallListenerInterface();
    }

    public boolean canCallListenerInterface(Component component, Method method) {
        return this.canCallListenerInterface(component) && this.isEnabled(component) && component.canCallListenerInterface(method);
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
    }

    public void onConfigure(Component component) {
    }

    @Override
    public void onEvent(Component component, IEvent<?> event) {
    }
}

