/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.basic;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumLabel<T extends Enum<T>>
extends WebComponent {
    private static final long serialVersionUID = 1L;

    public EnumLabel(String id) {
        super(id);
    }

    public EnumLabel(String id, T value) {
        this(id, new Model<T>(value));
    }

    public EnumLabel(String id, IModel<T> model) {
        super(id, model);
    }

    @Override
    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.replaceComponentTagBody(markupStream, openTag, this.getStringValue());
    }

    private String getStringValue() {
        T value = this.getModelObject();
        String converted = value != null ? this.getString(this.resourceKey(value)) : this.nullValue();
        return this.getDefaultModelObjectAsString(converted);
    }

    protected String resourceKey(T value) {
        return ((Enum)value).getDeclaringClass().getSimpleName() + "." + ((Enum)value).name();
    }

    protected String nullValue() {
        return "";
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.setType(XmlTag.TagType.OPEN);
    }

    public final IModel<T> getModel() {
        return this.getDefaultModel();
    }

    public final void setModel(IModel<T> model) {
        this.setDefaultModel(model);
    }

    public final T getModelObject() {
        return (T)((Enum)this.getDefaultModelObject());
    }

    public final void setModelObject(T object) {
        this.setDefaultModelObject(object);
    }
}

