/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.Collection;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Check<T>
extends LabeledWebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private static final String ATTR_DISABLED = "disabled";
    private int uuid = -1;
    private final CheckGroup<T> group;

    public Check(String id) {
        this(id, null, null);
    }

    public Check(String id, IModel<T> model) {
        this(id, model, null);
    }

    public Check(String id, CheckGroup<T> group) {
        this(id, null, group);
    }

    public Check(String id, IModel<T> model, CheckGroup<T> group) {
        super(id, model);
        this.group = group;
        this.setOutputMarkupId(true);
    }

    public String getValue() {
        if (this.uuid < 0) {
            this.uuid = this.getPage().getAutoIndex();
        }
        return "check" + this.uuid;
    }

    protected CheckGroup<T> getGroup() {
        CheckGroup group = this.group;
        if (group == null && (group = this.findParent(CheckGroup.class)) == null) {
            throw new WicketRuntimeException("Check component [" + this.getPath() + "] cannot find its parent CheckGroup");
        }
        return group;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "input");
        this.checkComponentTagAttribute(tag, "type", "checkbox");
        CheckGroup<T> group = this.getGroup();
        String uuid = this.getValue();
        tag.put("name", group.getInputName());
        tag.put("value", uuid);
        Collection collection = (Collection)group.getDefaultModelObject();
        if (collection == null) {
            throw new WicketRuntimeException("CheckGroup [" + group.getPath() + "] contains a null model object, must be an object of type java.util.Collection");
        }
        if (group.hasRawInput()) {
            String[] inputArray = group.getInputAsArray();
            if (inputArray != null) {
                for (String input : inputArray) {
                    if (!uuid.equals(input)) continue;
                    tag.put("checked", "checked");
                }
            }
        } else if (collection.contains(this.getDefaultModelObject())) {
            tag.put("checked", "checked");
        }
        if (group.wantOnSelectionChangedNotifications()) {
            CharSequence url = group.urlFor(IOnChangeListener.INTERFACE, new PageParameters());
            Form form = group.findParent(Form.class);
            if (form != null) {
                tag.put("onclick", form.getJsForInterfaceUrl(url));
            } else {
                tag.put("onclick", "window.location.href='" + url + (((Object)url).toString().indexOf(63) > -1 ? "&" : "?") + group.getInputName() + "=' + this.value;");
            }
        }
        if (!(this.isActionAuthorized(ENABLE) && this.isEnabledInHierarchy() && group.isEnabledInHierarchy())) {
            tag.put(ATTR_DISABLED, ATTR_DISABLED);
        }
        String marker = "wicket-" + this.getGroup().getMarkupId();
        String clazz = tag.getAttribute("class");
        clazz = Strings.isEmpty((CharSequence)clazz) ? marker : clazz + " " + marker;
        tag.put("class", clazz);
    }

    public Check<T> setLabel(IModel<String> labelModel) {
        this.setLabelInternal(labelModel);
        return this;
    }

    public final IModel<T> getModel() {
        return this.getDefaultModel();
    }

    public final void setModel(IModel<T> model) {
        this.setDefaultModel((IModel)model);
    }

    public final T getModelObject() {
        return (T)this.getDefaultModelObject();
    }

    public final void setModelObject(T object) {
        this.setDefaultModelObject(object);
    }

    @Override
    protected boolean getStatelessHint() {
        return false;
    }
}

