/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.form.AbstractCheckSelector;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckBoxSelector
extends AbstractCheckSelector {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference JS = new PackageResourceReference(CheckBoxSelector.class, "CheckBoxSelector.js");
    private final String checkBoxIdArrayLiteral;

    public CheckBoxSelector(String id, CheckBox ... boxes) {
        super(id);
        this.setOutputMarkupId(true);
        this.checkBoxIdArrayLiteral = this.buildMarkupIdJSArrayLiteral(Arrays.asList(boxes));
    }

    @Override
    protected CharSequence getFindCheckboxesFunction() {
        return "Wicket.CheckboxSelector.Checkboxes.findCheckboxesFunction(" + this.checkBoxIdArrayLiteral + ")";
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderJavaScriptReference(JS);
    }

    private String buildMarkupIdJSArrayLiteral(Iterable<? extends Component> components) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        if (components.iterator().hasNext()) {
            for (Component component : components) {
                component.setOutputMarkupId(true);
                buf.append("'").append(component.getMarkupId()).append("', ");
            }
            buf.delete(buf.length() - 2, buf.length());
        }
        buf.append("]");
        return buf.toString();
    }
}

