/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore.memory;

import java.io.Serializable;
import org.apache.wicket.Session;
import org.apache.wicket.page.IPageManagerContext;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.pageStore.memory.DataStoreEvictionStrategy;
import org.apache.wicket.pageStore.memory.PageTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionDataStore
implements IDataStore {
    private static final Logger log = LoggerFactory.getLogger(HttpSessionDataStore.class);
    private static final String PAGE_TABLE_KEY = "page:store:memory";
    private final IPageManagerContext pageManagerContext;
    private final DataStoreEvictionStrategy evictionStrategy;

    public HttpSessionDataStore(IPageManagerContext pageManagerContext, DataStoreEvictionStrategy evictionStrategy) {
        this.pageManagerContext = pageManagerContext;
        this.evictionStrategy = evictionStrategy;
    }

    public byte[] getData(String sessionId, int pageId) {
        PageTable pageTable = this.getPageTable(false);
        byte[] pageAsBytes = null;
        if (pageTable != null) {
            pageAsBytes = pageTable.getPage(pageId);
        }
        return pageAsBytes;
    }

    public void removeData(String sessionId, int pageId) {
        PageTable pageTable = this.getPageTable(false);
        if (pageTable != null) {
            pageTable.removePage(pageId);
        }
    }

    public void removeData(String sessionId) {
        PageTable pageTable = this.getPageTable(false);
        if (pageTable != null) {
            pageTable.clear();
        }
    }

    public void storeData(String sessionId, int pageId, byte[] pageAsBytes) {
        PageTable pageTable = this.getPageTable(true);
        if (pageTable != null) {
            pageTable.storePage(pageId, pageAsBytes);
            this.evictionStrategy.evict(pageTable);
        } else {
            log.error("Cannot store the data for page with id '{}' in session with id '{}'", (Object)pageId, (Object)sessionId);
        }
    }

    public void destroy() {
    }

    public boolean isReplicated() {
        return true;
    }

    private PageTable getPageTable(boolean create) {
        PageTable pageTable = null;
        if (Session.exists() && (pageTable = (PageTable)((Object)this.pageManagerContext.getSessionAttribute(PAGE_TABLE_KEY))) == null && create) {
            pageTable = new PageTable();
            this.pageManagerContext.setSessionAttribute(PAGE_TABLE_KEY, (Serializable)((Object)pageTable));
        }
        return pageTable;
    }
}

