/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.handler;

import org.apache.wicket.Page;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.request.ILoggableRequestHandler;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestableComponent;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.handler.ComponentNotFoundException;
import org.apache.wicket.request.handler.IComponentRequestHandler;
import org.apache.wicket.request.handler.IIntrospectablePageProvider;
import org.apache.wicket.request.handler.IPageAndComponentProvider;
import org.apache.wicket.request.handler.IPageProvider;
import org.apache.wicket.request.handler.IPageRequestHandler;
import org.apache.wicket.request.handler.PageAndComponentProvider;
import org.apache.wicket.request.handler.PageProvider;
import org.apache.wicket.request.handler.RenderPageRequestHandler;
import org.apache.wicket.request.handler.logger.ListenerInterfaceLogData;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerInterfaceRequestHandler
implements IPageRequestHandler,
IComponentRequestHandler,
ILoggableRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ListenerInterfaceRequestHandler.class);
    private final IPageAndComponentProvider pageComponentProvider;
    private final RequestListenerInterface listenerInterface;
    private final Integer behaviorId;
    private ListenerInterfaceLogData logData;

    public ListenerInterfaceRequestHandler(IPageAndComponentProvider pageComponentProvider, RequestListenerInterface listenerInterface, Integer behaviorIndex) {
        Args.notNull((Object)pageComponentProvider, (String)"pageComponentProvider");
        Args.notNull((Object)listenerInterface, (String)"listenerInterface");
        this.pageComponentProvider = pageComponentProvider;
        this.listenerInterface = listenerInterface;
        this.behaviorId = behaviorIndex;
    }

    public ListenerInterfaceRequestHandler(PageAndComponentProvider pageComponentProvider, RequestListenerInterface listenerInterface) {
        this(pageComponentProvider, listenerInterface, null);
    }

    @Override
    public IRequestableComponent getComponent() {
        return this.pageComponentProvider.getComponent();
    }

    @Override
    public IRequestablePage getPage() {
        return this.pageComponentProvider.getPageInstance();
    }

    @Override
    public Class<? extends IRequestablePage> getPageClass() {
        return this.pageComponentProvider.getPageClass();
    }

    @Override
    public Integer getPageId() {
        return this.pageComponentProvider.getPageId();
    }

    @Override
    public PageParameters getPageParameters() {
        return this.pageComponentProvider.getPageParameters();
    }

    public void detach(IRequestCycle requestCycle) {
        if (this.logData == null) {
            this.logData = new ListenerInterfaceLogData(this.pageComponentProvider, this.listenerInterface, this.behaviorId);
        }
        this.pageComponentProvider.detach();
    }

    public RequestListenerInterface getListenerInterface() {
        return this.listenerInterface;
    }

    public Integer getBehaviorIndex() {
        return this.behaviorId;
    }

    public void respond(IRequestCycle requestCycle) {
        IRequestablePage page = this.getPage();
        boolean freshPage = this.pageComponentProvider.isPageInstanceFresh();
        boolean isAjax = ((WebRequest)requestCycle.getRequest()).isAjax();
        IRequestableComponent component = null;
        try {
            component = this.getComponent();
        }
        catch (ComponentNotFoundException e) {
            component = null;
        }
        if (component == null && freshPage || component != null && this.getComponent().getPage() == page) {
            boolean isStateless;
            if (page instanceof Page) {
                ((Page)page).internalInitialize();
            }
            RenderPageRequestHandler.RedirectPolicy policy = (isStateless = page.isPageStateless()) ? RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT : RenderPageRequestHandler.RedirectPolicy.AUTO_REDIRECT;
            PageProvider pageProvider = new PageProvider(page);
            if (freshPage && !isStateless) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("A ListenerInterface '{}' assigned to '{}' is executed on an expired stateful page. Scheduling re-create of the page and ignoring the listener interface...", (Object)this.listenerInterface, (Object)this.getComponentPath());
                }
                if (isAjax) {
                    policy = RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT;
                }
                requestCycle.scheduleRequestHandlerAfterCurrent((IRequestHandler)new RenderPageRequestHandler(pageProvider, policy));
                return;
            }
            if (!isAjax && this.listenerInterface.isRenderPageAfterInvocation()) {
                requestCycle.scheduleRequestHandlerAfterCurrent((IRequestHandler)new RenderPageRequestHandler(pageProvider, policy));
            }
        } else {
            throw new WicketRuntimeException("Component " + this.getComponent() + " has been removed from page.");
        }
        this.invokeListener();
    }

    private void invokeListener() {
        if (this.getBehaviorIndex() == null) {
            this.listenerInterface.invoke(this.getComponent());
        } else {
            try {
                Behavior behavior = this.getComponent().getBehaviorById(this.behaviorId);
                this.listenerInterface.invoke(this.getComponent(), behavior);
            }
            catch (IndexOutOfBoundsException e) {
                throw new WicketRuntimeException("Couldn't find component behavior.", e);
            }
        }
    }

    @Override
    public final boolean isPageInstanceCreated() {
        if (!(this.pageComponentProvider instanceof IIntrospectablePageProvider)) {
            LOG.warn("{} used by this application does not implement {}, the request handler is falling back on using incorrect behavior", IPageProvider.class, IIntrospectablePageProvider.class);
            return !this.pageComponentProvider.isNewPageInstance();
        }
        return this.pageComponentProvider.hasPageInstance();
    }

    @Override
    public final String getComponentPath() {
        return this.pageComponentProvider.getComponentPath();
    }

    @Override
    public final Integer getRenderCount() {
        return this.pageComponentProvider.getRenderCount();
    }

    public ListenerInterfaceLogData getLogData() {
        return this.logData;
    }
}

