/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.loader;

import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.resource.loader.ComponentStringResourceLoader;
import org.apache.wicket.validation.IValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorStringResourceLoader
extends ComponentStringResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(ValidatorStringResourceLoader.class);

    @Override
    public String loadStringResource(Class<?> clazz, String key, Locale locale, String style, String variation) {
        if (clazz == null || !IValidator.class.isAssignableFrom(clazz)) {
            return null;
        }
        return super.loadStringResource(clazz, key, locale, style, variation);
    }

    @Override
    public String loadStringResource(Component component, String key, Locale locale, String style, String variation) {
        if (component == null || !(component instanceof FormComponent)) {
            return null;
        }
        FormComponent fc = (FormComponent)component;
        for (IValidator validator : fc.getValidators()) {
            String resource = this.loadStringResource(validator.getClass(), key, locale, style, variation);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }
}

