/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource.locator;

import java.util.Iterator;
import java.util.Locale;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.resource.locator.ExtensionResourceNameIterator;
import org.apache.wicket.util.resource.locator.LocaleResourceNameIterator;
import org.apache.wicket.util.resource.locator.StyleAndVariationResourceNameIterator;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceNameIterator
implements Iterator<String> {
    private final String path;
    private final String extensions;
    private final Locale locale;
    private final boolean strict;
    private final StyleAndVariationResourceNameIterator styleIterator;
    private LocaleResourceNameIterator localeIterator;
    private ExtensionResourceNameIterator extensionsIterator;

    public ResourceNameIterator(String path, String style, String variation, Locale locale, String extensions, boolean strict) {
        this.locale = locale;
        if (extensions == null && path != null && path.indexOf(46) != -1) {
            this.extensions = Strings.afterLast((String)path, (char)'.');
            this.path = Strings.beforeLast((String)path, (char)'.');
        } else {
            this.extensions = extensions;
            this.path = path;
        }
        this.styleIterator = this.newStyleAndVariationResourceNameIterator(style, variation);
        this.strict = strict;
    }

    public final Locale getLocale() {
        return this.localeIterator.getLocale();
    }

    public final String getStyle() {
        return this.styleIterator.getStyle();
    }

    public final String getVariation() {
        return this.styleIterator.getVariation();
    }

    public final String getExtension() {
        return this.extensionsIterator.getExtension();
    }

    @Override
    public boolean hasNext() {
        if (this.extensionsIterator != null) {
            if (this.extensionsIterator.hasNext()) {
                return true;
            }
            this.extensionsIterator = null;
        }
        if (this.localeIterator != null) {
            while (this.localeIterator.hasNext()) {
                this.localeIterator.next();
                this.extensionsIterator = this.newExtensionResourceNameIterator(this.extensions);
                if (!this.extensionsIterator.hasNext()) continue;
                return true;
            }
            this.localeIterator = null;
        }
        while (this.styleIterator.hasNext()) {
            this.styleIterator.next();
            this.localeIterator = this.newLocaleResourceNameIterator(this.locale, this.strict);
            while (this.localeIterator.hasNext()) {
                this.localeIterator.next();
                this.extensionsIterator = this.newExtensionResourceNameIterator(this.extensions);
                if (!this.extensionsIterator.hasNext()) continue;
                return true;
            }
            if (!this.strict) continue;
            break;
        }
        return false;
    }

    @Override
    public String next() {
        if (this.extensionsIterator != null) {
            this.extensionsIterator.next();
            return this.toString();
        }
        throw new WicketRuntimeException("Illegal call of next(). Iterator not properly initialized");
    }

    public String toString() {
        return this.path + this.prepend(this.getVariation(), '_') + this.prepend(this.getStyle(), '_') + this.prepend(this.getLocale(), '_') + this.prepend(this.getExtension(), '.');
    }

    private String prepend(Object string, char prepend) {
        return string != null ? prepend + string.toString() : "";
    }

    protected LocaleResourceNameIterator newLocaleResourceNameIterator(Locale locale, boolean strict) {
        return new LocaleResourceNameIterator(locale, strict);
    }

    protected StyleAndVariationResourceNameIterator newStyleAndVariationResourceNameIterator(String style, String variation) {
        return new StyleAndVariationResourceNameIterator(style, variation);
    }

    protected ExtensionResourceNameIterator newExtensionResourceNameIterator(String extensions) {
        return new ExtensionResourceNameIterator(extensions, ',');
    }

    @Override
    public void remove() {
    }
}

