/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.io.Serializable;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IGenericComponent;
import org.apache.wicket.Localizer;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AutoLabelResolver;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormModelUpdateListener;
import org.apache.wicket.markup.html.form.IFormVisitorParticipant;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IObjectClassAwareModel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.string.StringList;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.string.interpolator.VariableInterpolator;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitFilter;
import org.apache.wicket.util.visit.IVisitor;
import org.apache.wicket.util.visit.Visits;
import org.apache.wicket.validation.IErrorMessageSource;
import org.apache.wicket.validation.INullAcceptingValidator;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.apache.wicket.validation.ValidatorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FormComponent<T>
extends LabeledWebMarkupContainer
implements IFormVisitorParticipant,
IFormModelUpdateListener,
IGenericComponent<T, FormComponent<T>> {
    private static final Logger logger = LoggerFactory.getLogger(FormComponent.class);
    public static final String VALUE_SEPARATOR = ";";
    private static final String[] EMPTY_STRING_ARRAY = new String[]{""};
    private static final short FLAG_REQUIRED = 1024;
    private static final String NO_RAW_INPUT = "[-NO-RAW-INPUT-]";
    private static final long serialVersionUID = 1L;
    protected static final short FLAG_CONVERT_EMPTY_INPUT_STRING_TO_NULL = 256;
    private transient T convertedInput;
    private String rawInput = "[-NO-RAW-INPUT-]";
    private String typeName;

    @Override
    protected void onBeforeRender() {
        this.getRequestCycle().find(IPartialPageRequestHandler.class).ifPresent(handler -> this.updateAutoLabels((IPartialPageRequestHandler)handler, true));
        super.onBeforeRender();
    }

    public static <R> R visitFormComponentsPostOrder(Component component, IVisitor<? extends FormComponent<?>, R> visitor) {
        return (R)Visits.visitPostOrder((Object)component, visitor, (IVisitFilter)new IVisitFilter(){

            public boolean visitChildren(Object object) {
                if (object instanceof IFormVisitorParticipant) {
                    return ((IFormVisitorParticipant)object).processChildren();
                }
                return true;
            }

            public boolean visitObject(Object object) {
                return object instanceof FormComponent;
            }
        });
    }

    public static <R> R visitComponentsPostOrder(Component component, IVisitor<Component, R> visitor) {
        Args.notNull(visitor, (String)"visitor");
        return (R)Visits.visitPostOrder((Object)component, visitor, (IVisitFilter)new IVisitFilter(){

            public boolean visitObject(Object object) {
                return true;
            }

            public boolean visitChildren(Object object) {
                if (object instanceof IFormVisitorParticipant) {
                    return ((IFormVisitorParticipant)object).processChildren();
                }
                return true;
            }
        });
    }

    public FormComponent(String id) {
        this(id, (IModel<T>)null);
    }

    public FormComponent(String id, IModel<T> model) {
        super(id, model);
        this.setVersioned(false);
    }

    public final String getDefaultLabel() {
        return this.getDefaultLabel(this.getId());
    }

    public final String getDefaultLabel(String defaultValue) {
        return this.getLocalizer().getString(this.getId(), (Component)this.getParent(), defaultValue);
    }

    public final FormComponent<T> add(IValidator<? super T> validator) {
        Args.notNull(validator, (String)"validator");
        if (validator instanceof Behavior) {
            this.add((Behavior)((Object)validator));
        } else {
            this.add(new Behavior[]{new ValidatorAdapter<T>(validator)});
        }
        return this;
    }

    public final FormComponent<T> remove(IValidator<? super T> validator) {
        Args.notNull(validator, (String)"validator");
        Behavior match = null;
        for (Behavior behavior : this.getBehaviors()) {
            if (behavior.equals(validator)) {
                match = behavior;
                break;
            }
            if (!(behavior instanceof ValidatorAdapter) || !((ValidatorAdapter)behavior).getValidator().equals(validator)) continue;
            match = behavior;
            break;
        }
        if (match == null) {
            throw new IllegalStateException("Tried to remove validator that was not previously added. Make sure your validator's equals() implementation is sufficient");
        }
        this.remove(match);
        return this;
    }

    public final FormComponent<T> add(IValidator<? super T> ... validators) {
        Args.notNull(validators, (String)"validators");
        for (IValidator<? super T> validator : validators) {
            this.add(validator);
        }
        return this;
    }

    public boolean checkRequired() {
        if (this.isRequired()) {
            String input = this.getInput();
            if (input == null && !this.isInputNullable() && !this.isEnabledInHierarchy()) {
                return true;
            }
            return !Strings.isEmpty((String)input);
        }
        return true;
    }

    public void clearInput() {
        this.rawInput = NO_RAW_INPUT;
    }

    public void error(IValidationError error) {
        Args.notNull((Object)error, (String)"error");
        MessageSource source = new MessageSource();
        Object message = error.getErrorMessage(source);
        if (message == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Could not locate error message for component: ");
            buffer.append(Classes.simpleName(this.getClass()));
            buffer.append("@");
            buffer.append(this.getPageRelativePath());
            buffer.append(" and error: ");
            buffer.append(error.toString());
            buffer.append(". Tried keys: ");
            Iterator<String> keys = source.triedKeys.iterator();
            while (keys.hasNext()) {
                buffer.append(keys.next());
                if (!keys.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('.');
            message = buffer.toString();
            logger.warn(message.toString());
        }
        this.error((Serializable)message);
    }

    public final T getConvertedInput() {
        return this.convertedInput;
    }

    public final void setConvertedInput(T convertedInput) {
        this.convertedInput = convertedInput;
    }

    public Form<?> getForm() {
        Form<?> form = Form.findForm(this);
        if (form == null) {
            throw new WicketRuntimeException("Could not find Form parent for " + this);
        }
        return form;
    }

    public String getInput() {
        String[] input = this.getInputAsArray();
        if (input == null || input.length == 0) {
            return null;
        }
        return this.trim(input[0]);
    }

    public String[] getInputAsArray() {
        List<StringValue> list = this.getParameterValues(this.getInputName());
        String[] values = null;
        if (list != null) {
            values = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                values[i] = list.get(i).toString();
            }
        }
        if (!this.isInputNullable() && values != null && values.length == 1 && values[0] == null) {
            return EMPTY_STRING_ARRAY;
        }
        return values;
    }

    protected List<StringValue> getParameterValues(String inputName) {
        IRequestParameters parameters = Form.getRequestParameters(this);
        return parameters.getParameterValues(inputName);
    }

    public String getInputName() {
        String inputName = Form.getRootFormRelativeId(this);
        Form form = this.findParent(Form.class);
        if (form != null) {
            return form.getInputNamePrefix() + inputName;
        }
        return inputName;
    }

    public final String getRawInput() {
        return NO_RAW_INPUT.equals(this.rawInput) ? null : this.rawInput;
    }

    public final Class<T> getType() {
        return this.typeName == null ? null : WicketObjects.resolveClass(this.typeName);
    }

    public String getValidatorKeyPrefix() {
        Form form = this.findParent(Form.class);
        if (form != null) {
            return this.getForm().getValidatorKeyPrefix();
        }
        return null;
    }

    public final List<IValidator<? super T>> getValidators() {
        ArrayList<IValidator> list = new ArrayList<IValidator>();
        for (Behavior behavior : this.getBehaviors()) {
            if (!(behavior instanceof IValidator)) continue;
            list.add((IValidator)((Object)behavior));
        }
        return Collections.unmodifiableList(list);
    }

    public final String getValue() {
        if (NO_RAW_INPUT.equals(this.rawInput)) {
            return this.getModelValue();
        }
        if (this.getEscapeModelStrings() && this.rawInput != null) {
            return Strings.escapeMarkup((CharSequence)this.rawInput).toString();
        }
        return this.rawInput;
    }

    public final boolean hasRawInput() {
        return !NO_RAW_INPUT.equals(this.rawInput);
    }

    public final void inputChanged() {
        if (this.isVisibleInHierarchy() && this.isEnabledInHierarchy()) {
            String[] input = this.getInputAsArray();
            this.rawInput = input != null && input.length > 0 && input[0] != null ? StringList.valueOf((String[])input).join(VALUE_SEPARATOR) : (this.isInputNullable() ? null : NO_RAW_INPUT);
        }
    }

    public final void invalid() {
        this.onInvalid();
    }

    public boolean isInputNullable() {
        return true;
    }

    public boolean isMultiPart() {
        return false;
    }

    public boolean isRequired() {
        return this.getFlag(1024);
    }

    public final boolean isValid() {
        class IsValidVisitor
        implements IVisitor<FormComponent<?>, Boolean> {
            IsValidVisitor() {
            }

            public void component(FormComponent<?> formComponent, IVisit<Boolean> visit) {
                if (formComponent.hasErrorMessage()) {
                    visit.stop((Object)Boolean.FALSE);
                }
            }
        }
        IsValidVisitor tmp = new IsValidVisitor();
        Object result = FormComponent.visitFormComponentsPostOrder(this, tmp);
        return Boolean.FALSE != result;
    }

    @Override
    public boolean processChildren() {
        return true;
    }

    public final void processInput() {
        this.inputChanged();
        this.validate();
        if (this.hasErrorMessage()) {
            this.invalid();
        } else {
            this.valid();
            this.updateModel();
        }
    }

    @Override
    public FormComponent<T> setLabel(IModel<String> labelModel) {
        super.setLabel(labelModel);
        return this;
    }

    public void setModelValue(String[] value) {
        this.convertedInput = this.convertValue(value);
        this.updateModel();
    }

    public final FormComponent<T> setRequired(boolean required) {
        if (!required && this.getType() != null && this.getType().isPrimitive()) {
            throw new WicketRuntimeException("FormComponent has to be required when the type is primitive class: " + this);
        }
        if (required != this.isRequired()) {
            this.addStateChange();
        }
        this.setFlag(1024, required);
        return this;
    }

    public FormComponent<T> setType(Class<?> type) {
        String string = this.typeName = type == null ? null : type.getName();
        if (type != null && type.isPrimitive()) {
            this.setRequired(true);
        }
        return this;
    }

    @Override
    public void updateModel() {
        this.setModelObject(this.getConvertedInput());
    }

    public final void valid() {
        this.clearInput();
        this.onValid();
    }

    public void validate() {
        if (this.hasFeedbackMessage()) {
            this.getFeedbackMessages().clear();
        }
        this.validateRequired();
        if (this.isValid()) {
            this.convertInput();
            if (this.isValid()) {
                if (this.isRequired() && this.getConvertedInput() == null && this.isInputNullable()) {
                    this.reportRequiredError();
                } else {
                    this.validateValidators();
                }
            }
        }
    }

    public void convertInput() {
        if (this.typeName == null) {
            try {
                this.convertedInput = this.convertValue(this.getInputAsArray());
            }
            catch (ConversionException e) {
                this.error(this.newValidationError(e));
            }
        } else {
            IConverter<T> converter = this.getConverter(this.getType());
            try {
                this.convertedInput = converter.convertToObject(this.getInput(), this.getLocale());
            }
            catch (ConversionException e) {
                this.error(this.newValidationError(e));
            }
        }
    }

    protected ValidationError newValidationError(ConversionException cause) {
        Map variables;
        ValidationError error = new ValidationError(cause.getMessage());
        if (cause.getResourceKey() != null) {
            error.addKey(cause.getResourceKey());
        }
        if (this.typeName == null) {
            if (cause.getTargetType() != null) {
                error.addKey("ConversionError." + Classes.simpleName((Class)cause.getTargetType()));
            }
            error.addKey("ConversionError");
        } else {
            String simpleName = Classes.simpleName(this.getType());
            error.addKey("IConverter." + simpleName);
            error.addKey("IConverter");
            error.setVariable("type", simpleName);
        }
        Locale locale = cause.getLocale();
        if (locale != null) {
            error.setVariable("locale", locale);
        }
        error.setVariable("exception", (Object)cause);
        Format format = cause.getFormat();
        if (format instanceof SimpleDateFormat) {
            error.setVariable("format", ((SimpleDateFormat)format).toLocalizedPattern());
        }
        if ((variables = cause.getVariables()) != null) {
            error.getVariables().putAll(variables);
        }
        return error;
    }

    protected T convertValue(String[] value) throws ConversionException {
        return (T)(value != null && value.length > 0 && value[0] != null ? this.trim(value[0]) : null);
    }

    protected String getModelValue() {
        return this.getDefaultModelObjectAsString();
    }

    protected final int inputAsInt() {
        String string = this.getInput();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(this.exceptionMessage("Internal error.  Request string '" + string + "' not a valid integer"));
        }
    }

    protected final int inputAsInt(int defaultValue) {
        String string = this.getInput();
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(this.exceptionMessage("Request string '" + string + "' is not a valid integer"));
            }
        }
        return defaultValue;
    }

    protected final int[] inputAsIntArray() {
        String[] strings = this.getInputAsArray();
        if (strings != null) {
            int[] ints = new int[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                ints[i] = Integer.parseInt(strings[i]);
            }
            return ints;
        }
        return null;
    }

    @Override
    protected void internalOnModelChanged() {
        this.valid();
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        tag.put("name", this.getInputName());
        if (!this.isEnabledInHierarchy()) {
            this.onDisabled(tag);
        }
        super.onComponentTag(tag);
    }

    @Override
    protected void onDetach() {
        super.onDetach();
        this.convertedInput = null;
    }

    protected void onDisabled(ComponentTag tag) {
        tag.put("disabled", "disabled");
    }

    protected void onInvalid() {
    }

    protected void onValid() {
    }

    protected boolean shouldTrimInput() {
        return true;
    }

    protected String trim(String string) {
        String trimmed = string;
        if (trimmed != null && this.shouldTrimInput()) {
            trimmed = trimmed.trim();
        }
        return trimmed;
    }

    protected final void validateRequired() {
        if (!this.checkRequired()) {
            this.reportRequiredError();
        }
    }

    protected void reportRequiredError() {
        this.error(new ValidationError().addKey("Required"));
    }

    protected final void validateValidators() {
        IValidatable<T> validatable = this.newValidatable();
        boolean isNull = this.getConvertedInput() == null;
        for (Behavior behavior : this.getBehaviors()) {
            if (!this.isBehaviorAccepted(behavior)) continue;
            IValidator validator = null;
            if (behavior instanceof ValidatorAdapter) {
                validator = ((ValidatorAdapter)behavior).getValidator();
            } else if (behavior instanceof IValidator) {
                validator = (IValidator)((Object)behavior);
            }
            if (validator == null) continue;
            if (!isNull || validator instanceof INullAcceptingValidator) {
                try {
                    validator.validate(validatable);
                }
                catch (Exception e) {
                    throw new WicketRuntimeException("Exception '" + e.getMessage() + "' occurred during validation " + validator.getClass().getName() + " on component " + this.getPath(), e);
                }
            }
            if (this.isValid()) continue;
            break;
        }
    }

    public final IValidatable<T> newValidatable() {
        return new ValidatableAdapter();
    }

    public final void updateAutoLabels(IPartialPageRequestHandler target, boolean checkAuto) {
        AutoLabelResolver.AutoLabelMarker marker = (AutoLabelResolver.AutoLabelMarker)this.getMetaData((MetaDataKey)AutoLabelResolver.MARKER_KEY);
        if (marker == null) {
            return;
        }
        if (checkAuto) {
            if (!marker.isAuto()) {
                return;
            }
            marker.updateFrom(this, target);
            return;
        }
        marker.updateFrom(this, target);
    }

    @Deprecated(since="9.17.0, 10.0.0", forRemoval=true)
    public final void updateAutoLabels(AjaxRequestTarget target) {
        this.updateAutoLabels(target, false);
    }

    public boolean isFormParticipant() {
        boolean outsideParentForm = false;
        for (MarkupContainer parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof IFormVisitorParticipant && !((IFormVisitorParticipant)((Object)parent)).processChildren() && !outsideParentForm) {
                return false;
            }
            if (!(parent instanceof Form)) continue;
            Form form = (Form)parent;
            if (!form.wantSubmitOnParentFormSubmit()) {
                return false;
            }
            if (form != this.getForm()) continue;
            outsideParentForm = true;
        }
        return true;
    }

    public static <S> void updateCollectionModel(FormComponent<Collection<S>> formComponent) {
        Collection<S> collection;
        Collection<S> convertedInput = formComponent.getConvertedInput();
        if (convertedInput == null) {
            convertedInput = Collections.emptyList();
        }
        if ((collection = (Collection<S>)formComponent.getModelObject()) == null) {
            Class hint = null;
            if (formComponent.getModel() instanceof IObjectClassAwareModel) {
                hint = ((IObjectClassAwareModel)formComponent.getModel()).getObjectClass();
            }
            if (hint == null) {
                hint = List.class;
            }
            collection = FormComponent.newCollection(hint, convertedInput);
            formComponent.setModelObject(collection);
        } else {
            block11: {
                boolean modified = false;
                formComponent.modelChanging();
                try {
                    collection.clear();
                    collection.addAll(convertedInput);
                    modified = true;
                }
                catch (UnsupportedOperationException unmodifiable) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("An error occurred while trying to modify the collection attached to " + formComponent, (Throwable)unmodifiable);
                    }
                    collection = FormComponent.newCollection(collection.getClass(), convertedInput);
                }
                try {
                    formComponent.getModel().setObject(collection);
                }
                catch (Exception noSetter) {
                    if (!modified) {
                        throw new WicketRuntimeException("An error occurred while trying to set the collection attached to " + formComponent, noSetter);
                    }
                    if (!logger.isDebugEnabled()) break block11;
                    logger.debug("An error occurred while trying to set the collection attached to " + formComponent, (Throwable)noSetter);
                }
            }
            formComponent.modelChanged();
        }
    }

    private static <S> Collection<S> newCollection(Class<?> hint, Collection<S> elements) {
        if (Set.class.isAssignableFrom(hint)) {
            return new LinkedHashSet<S>(elements);
        }
        return new ArrayList<S>(elements);
    }

    private class MessageSource
    implements IErrorMessageSource {
        private final Set<String> triedKeys = new LinkedHashSet<String>();

        private MessageSource() {
        }

        @Override
        public String getMessage(String key, Map<String, Object> vars) {
            FormComponent formComponent = FormComponent.this;
            Localizer localizer = formComponent.getLocalizer();
            String prefix = formComponent.getValidatorKeyPrefix();
            Object resource = FormComponent.this.getId() + "." + this.prefix(prefix, key);
            String message = this.getString(localizer, (String)resource, formComponent);
            if (Strings.isEmpty((String)message) && Strings.isEmpty((String)prefix)) {
                resource = FormComponent.this.getId() + "." + key;
                message = this.getString(localizer, (String)resource, formComponent);
            }
            if (Strings.isEmpty((String)message)) {
                resource = this.prefix(prefix, key);
                message = this.getString(localizer, (String)resource, formComponent);
            }
            if (Strings.isEmpty((String)message)) {
                message = this.getString(localizer, key, formComponent);
            }
            message = Strings.isEmpty((String)message) ? null : this.substitute(message, this.addDefaultVars(vars));
            return message;
        }

        private String prefix(String prefix, String key) {
            if (!Strings.isEmpty((String)prefix)) {
                return prefix + "." + key;
            }
            return key;
        }

        private String getString(Localizer localizer, String key, Component component) {
            this.triedKeys.add(key);
            return localizer.getString(key, component, "");
        }

        private String substitute(String string, final Map<String, Object> vars) throws IllegalStateException {
            return new VariableInterpolator(string, Application.get().getResourceSettings().getThrowExceptionOnMissingResource()){
                private static final long serialVersionUID = 1L;

                protected String getValue(String variableName) {
                    Object value = vars.get(variableName);
                    if (value == null || value instanceof String) {
                        return String.valueOf(value);
                    }
                    IConverter<?> converter = FormComponent.this.getConverter(value.getClass());
                    if (converter == null) {
                        return Strings.toString(value);
                    }
                    return converter.convertToString(value, FormComponent.this.getLocale());
                }
            }.toString();
        }

        private Map<String, Object> addDefaultVars(Map<String, Object> params) {
            HashMap<String, Object> fullParams;
            if (params == null) {
                fullParams = new HashMap<String, Object>(6);
            } else {
                fullParams = new HashMap(params.size() + 6);
                fullParams.putAll(params);
            }
            if (!fullParams.containsKey("input")) {
                fullParams.put("input", FormComponent.this.getInput());
            }
            if (!fullParams.containsKey("name")) {
                fullParams.put("name", FormComponent.this.getId());
            }
            if (!fullParams.containsKey("label")) {
                fullParams.put("label", this.getLabel());
            }
            return fullParams;
        }

        private String getLabel() {
            FormComponent fc = FormComponent.this;
            String label = null;
            if (fc.getLabel() != null) {
                label = fc.getLabel().getObject();
            }
            if (label == null) {
                label = fc.getDefaultLabel();
            }
            return label;
        }
    }

    private class ValidatableAdapter
    implements IValidatable<T> {
        private ValidatableAdapter() {
        }

        @Override
        public void error(IValidationError error) {
            FormComponent.this.error(error);
        }

        @Override
        public T getValue() {
            return FormComponent.this.getConvertedInput();
        }

        @Override
        public boolean isValid() {
            return FormComponent.this.isValid();
        }

        @Override
        public IModel<T> getModel() {
            return FormComponent.this.getModel();
        }
    }
}

