/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.core.util.string.interpolator.ConvertingPropertyVariableInterpolator;
import org.apache.wicket.markup.repeater.AbstractRepeater;
import org.apache.wicket.model.IModel;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.settings.IResourceSettings;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Localizer {
    private static final Logger log = LoggerFactory.getLogger(Localizer.class);
    private static final String NULL_VALUE = "<null-value>";
    private Map<String, String> cache = this.newCache();
    private final ClassMetaDatabase metaDatabase = new ClassMetaDatabase();

    public static Localizer get() {
        return Application.get().getResourceSettings().getLocalizer();
    }

    public final void clearCache() {
        if (this.cache != null) {
            this.cache = this.newCache();
        }
    }

    public String getString(String key, Component component) throws MissingResourceException {
        return this.getString(key, component, null, null, null, null);
    }

    public String getString(String key, Component component, IModel<?> model) throws MissingResourceException {
        return this.getString(key, component, model, null, null, null);
    }

    public String getString(String key, Component component, String defaultValue) throws MissingResourceException {
        return this.getString(key, component, null, null, null, defaultValue);
    }

    public String getString(String key, Component component, IModel<?> model, String defaultValue) throws MissingResourceException {
        return this.getString(key, component, model, null, null, defaultValue);
    }

    public String getString(String key, Component component, IModel<?> model, Locale locale, String style, String defaultValue) throws MissingResourceException {
        IResourceSettings resourceSettings = Application.get().getResourceSettings();
        String value = this.getStringIgnoreSettings(key, component, model, locale, style, null);
        if (value == null && defaultValue != null && resourceSettings.getUseDefaultOnMissingResource()) {
            value = defaultValue;
            return this.substitutePropertyExpressions(component, value, model);
        }
        if (value != null) {
            return value;
        }
        if (resourceSettings.getThrowExceptionOnMissingResource()) {
            AppendingStringBuffer message = new AppendingStringBuffer((CharSequence)"Unable to find property: '");
            message.append(key);
            message.append("'");
            if (component != null) {
                message.append(" for component: ");
                message.append(component.getPageRelativePath());
                message.append(" [class=").append(component.getClass().getName()).append("]");
            }
            message.append(". Locale: ").append((Object)locale).append(", style: ").append(style);
            throw new MissingResourceException(message.toString(), component != null ? component.getClass().getName() : "", key);
        }
        return "[Warning: Property for '" + key + "' not found]";
    }

    public final String getStringIgnoreSettings(String key, Component component, IModel<?> model, String defaultValue) {
        return this.getStringIgnoreSettings(key, component, model, null, null, defaultValue);
    }

    public final String getStringIgnoreSettings(String key, Component component, IModel<?> model, Locale locale, String style, String defaultValue) {
        String variation;
        boolean addedToPage = false;
        if (component != null) {
            if (component instanceof Page || null != component.findParent(Page.class)) {
                addedToPage = true;
            }
            if (!addedToPage && log.isWarnEnabled()) {
                log.warn("Tried to retrieve a localized string for a component that has not yet been added to the page. This can sometimes lead to an invalid or no localized resource returned. Make sure you are not calling Component#getString() inside your Component's constructor. Offending component: {}", (Object)component);
            }
        }
        String cacheKey = null;
        String value = null;
        String string = variation = component != null ? component.getVariation() : null;
        if (locale == null && component != null) {
            locale = component.getLocale();
        }
        if (locale == null) {
            Locale locale2 = locale = Session.exists() ? Session.get().getLocale() : Locale.getDefault();
        }
        if (style == null && component != null) {
            style = component.getStyle();
        }
        if (style == null) {
            String string2 = style = Session.exists() ? Session.get().getStyle() : null;
        }
        if (this.cache != null && (component == null || addedToPage)) {
            cacheKey = this.getCacheKey(key, component, locale, style, variation);
        }
        if (cacheKey != null && this.cache.containsKey(cacheKey)) {
            value = this.getFromCache(cacheKey);
            if (log.isDebugEnabled()) {
                log.debug("Property found in cache: '" + key + "'; Component: '" + (component != null ? component.toString(false) : null) + "'; value: '" + value + '\'');
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Locate property: key: '" + key + "'; Component: '" + (component != null ? component.toString(false) : null) + '\'');
            }
            Iterator<IStringResourceLoader> iter = this.getStringResourceLoaders().iterator();
            value = null;
            while (iter.hasNext() && value == null) {
                IStringResourceLoader loader = iter.next();
                value = loader.loadStringResource(component, key, locale, style, variation);
            }
            if (cacheKey != null) {
                this.putIntoCache(cacheKey, value);
            }
            if (value == null && log.isDebugEnabled()) {
                log.debug("Property not found; key: '" + key + "'; Component: '" + (component != null ? component.toString(false) : null) + '\'');
            }
        }
        if (value == null) {
            value = defaultValue;
        }
        if (value != null) {
            return this.substitutePropertyExpressions(component, value, model);
        }
        return null;
    }

    protected List<IStringResourceLoader> getStringResourceLoaders() {
        return Application.get().getResourceSettings().getStringResourceLoaders();
    }

    protected void putIntoCache(String cacheKey, String string) {
        if (this.cache == null) {
            return;
        }
        if (string == null) {
            this.cache.put(cacheKey, NULL_VALUE);
        } else {
            this.cache.put(cacheKey, string);
        }
    }

    protected String getFromCache(String cacheKey) {
        if (this.cache == null) {
            return null;
        }
        String value = this.cache.get(cacheKey);
        if (NULL_VALUE == value) {
            return null;
        }
        return value;
    }

    protected String getCacheKey(String key, Component component, Locale locale, String style, String variation) {
        if (component != null) {
            StringBuilder buffer = new StringBuilder(200);
            buffer.append(key);
            Component cursor = component;
            while (cursor != null) {
                buffer.append('-').append(this.metaDatabase.id(cursor.getClass()));
                if (cursor instanceof Page) break;
                MarkupContainer parent = cursor.getParent();
                boolean skip = parent instanceof AbstractRepeater;
                if (!skip) {
                    String cursorKey = cursor.isAuto() ? "wicket-auto" : cursor.getId();
                    buffer.append(':').append(cursorKey);
                }
                cursor = parent;
            }
            buffer.append('-').append(locale);
            buffer.append('-').append(style);
            buffer.append('-').append(variation);
            return buffer.toString();
        }
        return key + '-' + locale.toString() + '-' + style;
    }

    public String substitutePropertyExpressions(Component component, String string, IModel<?> model) {
        if (string != null && model != null) {
            Locale locale;
            IConverterLocator locator;
            if (component == null) {
                locator = Application.get().getConverterLocator();
                locale = Session.exists() ? Session.get().getLocale() : Locale.getDefault();
            } else {
                locator = component;
                locale = component.getLocale();
            }
            return new ConvertingPropertyVariableInterpolator(string, model.getObject(), locator, locale).toString();
        }
        return string;
    }

    public final void setEnableCache(boolean value) {
        if (!value) {
            this.cache = null;
        } else if (this.cache == null) {
            this.cache = this.newCache();
        }
    }

    protected Map<String, String> newCache() {
        return new ConcurrentHashMap<String, String>();
    }

    private static class ClassMetaDatabase {
        private final ConcurrentMap<String, Long> nameToId = Generics.newConcurrentHashMap();
        private final AtomicLong nameCounter = new AtomicLong();

        private ClassMetaDatabase() {
        }

        public long id(Class<?> clazz) {
            Long previousId;
            String name = clazz.getName();
            Long id = (Long)this.nameToId.get(name);
            if (id == null && (previousId = this.nameToId.putIfAbsent(name, id = Long.valueOf(this.nameCounter.incrementAndGet()))) != null) {
                id = previousId;
            }
            return id;
        }
    }
}

