/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxChannel;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.ajax.attributes.IAjaxCallListener;
import org.apache.wicket.ajax.attributes.ThrottlingSettings;
import org.apache.wicket.ajax.json.JSONArray;
import org.apache.wicket.ajax.json.JSONException;
import org.apache.wicket.ajax.json.JSONObject;
import org.apache.wicket.ajax.json.JsonFunction;
import org.apache.wicket.ajax.json.JsonUtils;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.IComponentAwareHeaderContributor;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.CoreLibrariesContributor;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;

public abstract class AbstractDefaultAjaxBehavior
extends AbstractAjaxBehavior {
    private static final long serialVersionUID = 1L;
    public static final ResourceReference INDICATOR = new PackageResourceReference(AbstractDefaultAjaxBehavior.class, "indicator.gif");
    private static final String DYNAMIC_PARAMETER_FUNCTION_TEMPLATE = "function(attrs){%s}";
    private static final String PRECONDITION_FUNCTION_TEMPLATE = "function(attrs){%s}";
    private static final String COMPLETE_HANDLER_FUNCTION_TEMPLATE = "function(attrs, jqXHR, textStatus){%s}";
    private static final String FAILURE_HANDLER_FUNCTION_TEMPLATE = "function(attrs, jqXHR, errorMessage, textStatus){%s}";
    private static final String SUCCESS_HANDLER_FUNCTION_TEMPLATE = "function(attrs, jqXHR, data, textStatus){%s}";
    private static final String AFTER_HANDLER_FUNCTION_TEMPLATE = "function(attrs){%s}";
    private static final String BEFORE_SEND_HANDLER_FUNCTION_TEMPLATE = "function(attrs, jqXHR, settings){%s}";
    private static final String BEFORE_HANDLER_FUNCTION_TEMPLATE = "function(attrs){%s}";

    @Override
    protected void onBind() {
        this.getComponent().setOutputMarkupId(true);
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        CoreLibrariesContributor.contributeAjax(component.getApplication(), response);
        RequestCycle requestCycle = component.getRequestCycle();
        Url baseUrl = requestCycle.getUrlRenderer().getBaseUrl();
        CharSequence ajaxBaseUrl = Strings.escapeMarkup((CharSequence)baseUrl.toString());
        response.render(JavaScriptHeaderItem.forScript("Wicket.Ajax.baseUrl=\"" + ajaxBaseUrl + "\";", "wicket-ajax-base-url"));
        this.renderExtraHeaderContributors(component, response);
    }

    private void renderExtraHeaderContributors(Component component, IHeaderResponse response) {
        AjaxRequestAttributes attributes = this.getAttributes();
        List<IAjaxCallListener> ajaxCallListeners = attributes.getAjaxCallListeners();
        for (IAjaxCallListener ajaxCallListener : ajaxCallListeners) {
            if (!(ajaxCallListener instanceof IComponentAwareHeaderContributor)) continue;
            IComponentAwareHeaderContributor contributor = (IComponentAwareHeaderContributor)((Object)ajaxCallListener);
            contributor.renderHead(component, response);
        }
    }

    protected final AjaxRequestAttributes getAttributes() {
        AjaxRequestAttributes attributes = new AjaxRequestAttributes();
        this.updateAjaxAttributesBackwardCompatibility(attributes);
        this.updateAjaxAttributes(attributes);
        return attributes;
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    private void updateAjaxAttributesBackwardCompatibility(AjaxRequestAttributes attributes) {
        AjaxCallListener backwardCompatibleAjaxCallListener = new AjaxCallListener();
        backwardCompatibleAjaxCallListener.onSuccess(this.getSuccessScript());
        backwardCompatibleAjaxCallListener.onFailure(this.getFailureScript());
        backwardCompatibleAjaxCallListener.onPrecondition(this.getPreconditionScript());
        attributes.getAjaxCallListeners().add(backwardCompatibleAjaxCallListener);
        AjaxChannel channel = this.getChannel();
        if (channel != null) {
            attributes.setChannel(channel);
        }
    }

    protected final CharSequence renderAjaxAttributes(Component component) {
        AjaxRequestAttributes attributes = this.getAttributes();
        return this.renderAjaxAttributes(component, attributes);
    }

    protected final CharSequence renderAjaxAttributes(Component component, AjaxRequestAttributes attributes) {
        JSONObject attributesJson = new JSONObject();
        try {
            ThrottlingSettings throttlingSettings;
            String dataType;
            boolean wicketAjaxResponse;
            Duration requestTimeout;
            String[] eventNames;
            List<CharSequence> dynamicExtraParameters;
            String indicatorId;
            String submittingComponentId;
            String formId;
            attributesJson.put("u", this.getCallbackUrl());
            AjaxRequestAttributes.Method method = attributes.getMethod();
            if (AjaxRequestAttributes.Method.POST == method) {
                attributesJson.put("m", (Object)method);
            }
            if (!(component instanceof Page)) {
                String componentId = component.getMarkupId();
                attributesJson.put("c", componentId);
            }
            if (!Strings.isEmpty((CharSequence)(formId = attributes.getFormId()))) {
                attributesJson.put("f", formId);
            }
            if (attributes.isMultipart()) {
                attributesJson.put("mp", true);
            }
            if (!Strings.isEmpty((CharSequence)(submittingComponentId = attributes.getSubmittingComponentName()))) {
                attributesJson.put("sc", submittingComponentId);
            }
            if (!Strings.isEmpty((CharSequence)(indicatorId = this.findIndicatorId()))) {
                attributesJson.put("i", indicatorId);
            }
            for (IAjaxCallListener ajaxCallListener : attributes.getAjaxCallListeners()) {
                if (ajaxCallListener == null) continue;
                CharSequence beforeHandler = ajaxCallListener.getBeforeHandler(component);
                this.appendListenerHandler(beforeHandler, attributesJson, "bh", "function(attrs){%s}");
                CharSequence beforeSendHandler = ajaxCallListener.getBeforeSendHandler(component);
                this.appendListenerHandler(beforeSendHandler, attributesJson, "bsh", BEFORE_SEND_HANDLER_FUNCTION_TEMPLATE);
                CharSequence afterHandler = ajaxCallListener.getAfterHandler(component);
                this.appendListenerHandler(afterHandler, attributesJson, "ah", "function(attrs){%s}");
                CharSequence successHandler = ajaxCallListener.getSuccessHandler(component);
                this.appendListenerHandler(successHandler, attributesJson, "sh", SUCCESS_HANDLER_FUNCTION_TEMPLATE);
                CharSequence failureHandler = ajaxCallListener.getFailureHandler(component);
                this.appendListenerHandler(failureHandler, attributesJson, "fh", FAILURE_HANDLER_FUNCTION_TEMPLATE);
                CharSequence completeHandler = ajaxCallListener.getCompleteHandler(component);
                this.appendListenerHandler(completeHandler, attributesJson, "coh", COMPLETE_HANDLER_FUNCTION_TEMPLATE);
                CharSequence precondition = ajaxCallListener.getPrecondition(component);
                this.appendListenerHandler(precondition, attributesJson, "pre", "function(attrs){%s}");
            }
            JSONArray extraParameters = JsonUtils.asArray(attributes.getExtraParameters());
            if (extraParameters.length() > 0) {
                attributesJson.put("ep", extraParameters);
            }
            if ((dynamicExtraParameters = attributes.getDynamicExtraParameters()) != null) {
                for (CharSequence dynamicExtraParameter : dynamicExtraParameters) {
                    String func = String.format("function(attrs){%s}", dynamicExtraParameter);
                    JsonFunction function = new JsonFunction(func);
                    attributesJson.append("dep", function);
                }
            }
            if (!attributes.isAsynchronous()) {
                attributesJson.put("async", false);
            }
            if ((eventNames = attributes.getEventNames()).length == 1) {
                attributesJson.put("e", eventNames[0]);
            } else {
                for (String eventName : eventNames) {
                    attributesJson.append("e", eventName);
                }
            }
            AjaxChannel channel = attributes.getChannel();
            if (channel != null) {
                attributesJson.put("ch", channel);
            }
            if (attributes.isAllowDefault()) {
                attributesJson.put("ad", true);
            }
            if ((requestTimeout = attributes.getRequestTimeout()) != null) {
                attributesJson.put("rt", requestTimeout.getMilliseconds());
            }
            if (!(wicketAjaxResponse = attributes.isWicketAjaxResponse())) {
                attributesJson.put("wr", false);
            }
            if (!"xml".equals(dataType = attributes.getDataType())) {
                attributesJson.put("dt", dataType);
            }
            if ((throttlingSettings = attributes.getThrottlingSettings()) != null) {
                JSONObject throttlingSettingsJson = new JSONObject();
                throttlingSettingsJson.put("id", throttlingSettings.getId());
                throttlingSettingsJson.put("d", throttlingSettings.getDelay().getMilliseconds());
                if (throttlingSettings.getPostponeTimerOnUpdate()) {
                    throttlingSettingsJson.put("p", true);
                }
                attributesJson.put("tr", throttlingSettingsJson);
            }
            this.postprocessConfiguration(attributesJson, component);
        }
        catch (JSONException e) {
            throw new WicketRuntimeException(e);
        }
        String attributesAsJson = attributesJson.toString();
        return attributesAsJson;
    }

    private void appendListenerHandler(CharSequence handler, JSONObject attributesJson, String propertyName, String functionTemplate) throws JSONException {
        if (!Strings.isEmpty((CharSequence)handler)) {
            JsonFunction function;
            if (handler instanceof JsonFunction) {
                function = (JsonFunction)handler;
            } else {
                String func = String.format(functionTemplate, handler);
                function = new JsonFunction(func);
            }
            attributesJson.append(propertyName, function);
        }
    }

    protected void postprocessConfiguration(JSONObject attributesJson, Component component) throws JSONException {
    }

    public CharSequence getCallbackScript() {
        return this.getCallbackScript(this.getComponent());
    }

    protected CharSequence getCallbackScript(Component component) {
        CharSequence ajaxAttributes = this.renderAjaxAttributes(component);
        return "Wicket.Ajax.ajax(" + ajaxAttributes + ");";
    }

    public CharSequence getCallbackFunction(CallbackParameter ... extraParameters) {
        StringBuilder sb = new StringBuilder();
        sb.append("function (");
        boolean first = true;
        for (CallbackParameter curExtraParameter : extraParameters) {
            if (curExtraParameter.getFunctionParameterName() == null) continue;
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(curExtraParameter.getFunctionParameterName());
        }
        sb.append(") {\n");
        sb.append(this.getCallbackFunctionBody(extraParameters));
        sb.append("}\n");
        return sb;
    }

    public CharSequence getCallbackFunctionBody(CallbackParameter ... extraParameters) {
        AjaxRequestAttributes attributes = this.getAttributes();
        attributes.setEventNames(new String[0]);
        CharSequence attrsJson = this.renderAjaxAttributes(this.getComponent(), attributes);
        StringBuilder sb = new StringBuilder();
        sb.append("var attrs = ");
        sb.append(attrsJson);
        sb.append(";\n");
        sb.append("var params = {");
        boolean first = true;
        for (CallbackParameter curExtraParameter : extraParameters) {
            if (curExtraParameter.getAjaxParameterName() == null) continue;
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append('\'').append(curExtraParameter.getAjaxParameterName()).append("': ").append(curExtraParameter.getAjaxParameterCode());
        }
        sb.append("};\n");
        if (attributes.getExtraParameters().isEmpty()) {
            sb.append("attrs.ep = params;\n");
        } else {
            sb.append("attrs.ep = Wicket.merge(attrs.ep, params);\n");
        }
        sb.append("Wicket.Ajax.ajax(attrs);\n");
        return sb;
    }

    @Deprecated
    protected CharSequence getPreconditionScript() {
        return null;
    }

    @Deprecated
    protected CharSequence getFailureScript() {
        return null;
    }

    @Deprecated
    protected CharSequence getSuccessScript() {
        return null;
    }

    @Deprecated
    protected AjaxChannel getChannel() {
        return null;
    }

    protected String findIndicatorId() {
        if (this.getComponent() instanceof IAjaxIndicatorAware) {
            return ((IAjaxIndicatorAware)((Object)this.getComponent())).getAjaxIndicatorMarkupId();
        }
        if (this instanceof IAjaxIndicatorAware) {
            return ((IAjaxIndicatorAware)((Object)this)).getAjaxIndicatorMarkupId();
        }
        for (MarkupContainer parent = this.getComponent().getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof IAjaxIndicatorAware)) continue;
            return ((IAjaxIndicatorAware)((Object)parent)).getAjaxIndicatorMarkupId();
        }
        return null;
    }

    @Override
    public final void onRequest() {
        WebApplication app = (WebApplication)this.getComponent().getApplication();
        AjaxRequestTarget target = app.newAjaxRequestTarget(this.getComponent().getPage());
        RequestCycle requestCycle = RequestCycle.get();
        requestCycle.scheduleRequestHandlerAfterCurrent(target);
        this.respond(target);
    }

    protected abstract void respond(AjaxRequestTarget var1);
}

