/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html.form;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AbstractSubmitLink;
import org.apache.wicket.markup.html.form.Form;

public abstract class AjaxSubmitLink
extends AbstractSubmitLink {
    private static final long serialVersionUID = 1L;

    public AjaxSubmitLink(String id) {
        this(id, (Form<?>)null);
    }

    public AjaxSubmitLink(String id, Form<?> form) {
        super(id, form);
        this.add(new AjaxFormSubmitBehavior(form, "click"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onError(AjaxRequestTarget target) {
                AjaxSubmitLink.this.onError(target, this.getForm());
            }

            @Override
            protected Form<?> findForm() {
                return AjaxSubmitLink.this.getForm();
            }

            @Override
            protected void onComponentTag(ComponentTag tag) {
                if (AjaxSubmitLink.this.isLinkEnabled()) {
                    super.onComponentTag(tag);
                }
            }

            @Override
            public boolean getDefaultProcessing() {
                return AjaxSubmitLink.this.getDefaultFormProcessing();
            }

            @Override
            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AjaxSubmitLink.this.updateAjaxAttributes(attributes);
            }

            @Override
            protected void onSubmit(AjaxRequestTarget target) {
                AjaxSubmitLink.this.onSubmit(target, this.getForm());
            }

            @Override
            protected void onAfterSubmit(AjaxRequestTarget target) {
                AjaxSubmitLink.this.onAfterSubmit(target, this.getForm());
            }
        });
    }

    protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
    }

    protected void onAfterSubmit(AjaxRequestTarget target, Form<?> form) {
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.isLinkEnabled()) {
            if (tag.getName().toLowerCase().equals("a")) {
                tag.put("href", "#");
            }
        } else {
            this.disableLink(tag);
        }
    }

    @Override
    public final void onError() {
    }

    protected void onError(AjaxRequestTarget target, Form<?> form) {
    }

    @Override
    public final void onSubmit() {
    }

    @Override
    public final void onAfterSubmit() {
    }
}

