/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.lang;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.serialize.java.JavaSerializer;
import org.apache.wicket.settings.IApplicationSettings;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketObjects {
    private static final Logger log = LoggerFactory.getLogger(WicketObjects.class);
    private static IObjectSizeOfStrategy objectSizeOfStrategy = new SerializingObjectSizeOfStrategy();

    private WicketObjects() {
    }

    public static <T> Class<T> resolveClass(String className) {
        Class<?> resolved = null;
        try {
            if (Application.exists()) {
                resolved = Application.get().getApplicationSettings().getClassResolver().resolveClass(className);
            }
            if (resolved == null) {
                resolved = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            }
        }
        catch (ClassNotFoundException cnfx) {
            log.warn("Could not resolve class [" + className + "]", (Throwable)cnfx);
        }
        return resolved;
    }

    public static Object cloneModel(Object object) {
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(256);
            HashMap replacedObjects = Generics.newHashMap();
            ReplaceObjectOutputStream oos = new ReplaceObjectOutputStream(out, replacedObjects);
            oos.writeObject(object);
            ReplaceObjectInputStream ois = new ReplaceObjectInputStream(new ByteArrayInputStream(out.toByteArray()), replacedObjects, object.getClass().getClassLoader());
            return ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new WicketRuntimeException("Internal error cloning object", e);
        }
        catch (IOException e) {
            throw new WicketRuntimeException("Internal error cloning object", e);
        }
    }

    public static Object cloneObject(final Object object) {
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(256);
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(object);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(out.toByteArray())){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String className = desc.getName();
                    try {
                        return Class.forName(className, true, object.getClass().getClassLoader());
                    }
                    catch (ClassNotFoundException ex1) {
                        Class<?> candidate;
                        block5: {
                            log.debug("Class not found by using objects own classloader, trying the IClassResolver");
                            Application application = Application.get();
                            IApplicationSettings applicationSettings = application.getApplicationSettings();
                            IClassResolver classResolver = applicationSettings.getClassResolver();
                            candidate = null;
                            try {
                                candidate = classResolver.resolveClass(className);
                                if (candidate == null) {
                                    candidate = super.resolveClass(desc);
                                }
                            }
                            catch (WicketRuntimeException ex) {
                                if (!(ex.getCause() instanceof ClassNotFoundException)) break block5;
                                throw (ClassNotFoundException)ex.getCause();
                            }
                        }
                        return candidate;
                    }
                }
            };
            return ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new WicketRuntimeException("Internal error cloning object", e);
        }
        catch (IOException e) {
            throw new WicketRuntimeException("Internal error cloning object", e);
        }
    }

    public static Object newInstance(String className) {
        if (!Strings.isEmpty((CharSequence)className)) {
            try {
                Class c = WicketObjects.resolveClass(className);
                return c.newInstance();
            }
            catch (Exception e) {
                throw new WicketRuntimeException("Unable to create " + className, e);
            }
        }
        return null;
    }

    public static void setObjectSizeOfStrategy(IObjectSizeOfStrategy objectSizeOfStrategy) {
        WicketObjects.objectSizeOfStrategy = objectSizeOfStrategy == null ? new SerializingObjectSizeOfStrategy() : objectSizeOfStrategy;
        log.info("using " + objectSizeOfStrategy + " for calculating object sizes");
    }

    public static long sizeof(Serializable object) {
        return objectSizeOfStrategy.sizeOf(object);
    }

    private static final class ReplaceObjectOutputStream
    extends ObjectOutputStream {
        private final HashMap<String, Component> replacedComponents;

        private ReplaceObjectOutputStream(OutputStream out, HashMap<String, Component> replacedComponents) throws IOException {
            super(out);
            this.replacedComponents = replacedComponents;
            this.enableReplaceObject(true);
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            if (obj instanceof Component) {
                Component component = (Component)obj;
                String name = component.getPath();
                this.replacedComponents.put(name, component);
                return name;
            }
            return super.replaceObject(obj);
        }
    }

    private static final class ReplaceObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader classloader;
        private final HashMap<String, Component> replacedComponents;

        private ReplaceObjectInputStream(InputStream in, HashMap<String, Component> replacedComponents, ClassLoader classloader) throws IOException {
            super(in);
            this.replacedComponents = replacedComponents;
            this.classloader = classloader;
            this.enableResolveObject(true);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String className = desc.getName();
            try {
                return Class.forName(className, true, this.classloader);
            }
            catch (ClassNotFoundException ex1) {
                Class<?> candidate;
                block5: {
                    log.debug("Class not found by using objects own classloader, trying the IClassResolver");
                    Application application = Application.get();
                    IApplicationSettings applicationSettings = application.getApplicationSettings();
                    IClassResolver classResolver = applicationSettings.getClassResolver();
                    candidate = null;
                    try {
                        candidate = classResolver.resolveClass(className);
                        if (candidate == null) {
                            candidate = super.resolveClass(desc);
                        }
                    }
                    catch (WicketRuntimeException ex) {
                        if (!(ex.getCause() instanceof ClassNotFoundException)) break block5;
                        throw (ClassNotFoundException)ex.getCause();
                    }
                }
                return candidate;
            }
        }

        @Override
        protected Object resolveObject(Object obj) throws IOException {
            Component replaced = this.replacedComponents.get(obj);
            if (replaced != null) {
                return replaced;
            }
            return super.resolveObject(obj);
        }
    }

    public static final class SerializingObjectSizeOfStrategy
    implements IObjectSizeOfStrategy {
        @Override
        public long sizeOf(Serializable object) {
            if (object == null) {
                return 0L;
            }
            ISerializer serializer = Application.exists() ? Application.get().getFrameworkSettings().getSerializer() : new JavaSerializer("SerializingObjectSizeOfStrategy");
            byte[] serialized = serializer.serialize(object);
            int size = -1;
            if (serialized != null) {
                size = serialized.length;
            }
            return size;
        }
    }

    public static interface IObjectSizeOfStrategy {
        public long sizeOf(Serializable var1);
    }
}

