/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.include;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.resource.UrlResourceStream;
import org.apache.wicket.core.util.string.UrlUtils;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.resource.ResourceUtil;
import org.apache.wicket.util.resource.IResourceStream;

public class Include
extends WebComponent {
    private static final long serialVersionUID = 1L;
    private static final String VALID_SCHEME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+.-";

    public Include(String id) {
        super(id);
    }

    public Include(String id, IModel<String> model) {
        super(id, model);
    }

    public Include(String id, String modelObject) {
        super(id, new Model<String>(modelObject));
    }

    protected String importAsString() {
        String url = this.getDefaultModelObjectAsString();
        if (UrlUtils.isRelative((String)url)) {
            return this.importRelativeUrl(url);
        }
        return this.importAbsoluteUrl(url);
    }

    @Override
    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        String content = this.importAsString();
        this.replaceComponentTagBody(markupStream, openTag, content);
    }

    private String importRelativeUrl(CharSequence url) {
        HttpServletRequest req = (HttpServletRequest)this.getRequest().getContainerRequest();
        StringBuilder buildUrl = new StringBuilder(url.length());
        String scheme = req.getScheme();
        int port = req.getServerPort();
        buildUrl.append(scheme);
        buildUrl.append("://");
        buildUrl.append(req.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            buildUrl.append(':');
            buildUrl.append(req.getServerPort());
        }
        buildUrl.append(req.getContextPath()).append('/').append(url);
        return this.importAbsoluteUrl(buildUrl);
    }

    private String importAbsoluteUrl(CharSequence url) {
        try {
            return this.importUrl(new URL(((Object)url).toString()));
        }
        catch (MalformedURLException e) {
            throw new WicketRuntimeException(e);
        }
    }

    public Charset getCharset() {
        return null;
    }

    private final String importUrl(URL url) {
        return ResourceUtil.readString((IResourceStream)new UrlResourceStream(url), this.getCharset());
    }
}

