/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.util.value.IValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketContainerTagHandler
extends AbstractMarkupFilter {
    private static final Logger log = LoggerFactory.getLogger(WicketContainerTagHandler.class);
    private final boolean usesDevelopmentConfig;

    public WicketContainerTagHandler(boolean usesDevelopmentConfig) {
        this.usesDevelopmentConfig = usesDevelopmentConfig;
    }

    @Override
    protected final MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        if (this.usesDevelopmentConfig && tag instanceof WicketTag) {
            WicketTag wtag = (WicketTag)tag;
            if (tag.isOpen() && wtag.isContainerTag()) {
                this.handleContainerTag(wtag);
            }
        }
        return tag;
    }

    private void handleContainerTag(WicketTag containerTag) {
        IValueMap attributes = containerTag.getAttributes();
        for (String attribute : attributes.keySet()) {
            if (this.ignoreAttribute(attribute)) continue;
            this.reportAttribute(containerTag, attribute);
        }
    }

    private void reportAttribute(WicketTag containerTag, String attribute) {
        log.warn("wicket:container with id '{}' has attribute '{}' in markup, which will be ignored in deployment mode", (Object)containerTag.getId(), (Object)attribute);
    }

    private boolean ignoreAttribute(String attribute) {
        return attribute.equalsIgnoreCase(this.getWicketNamespace() + ":id");
    }
}

