/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.repeater;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.Component;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepeater
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(AbstractRepeater.class);
    private static Pattern SAFE_CHILD_ID_PATTERN = Pattern.compile("^\\d+$");

    public AbstractRepeater(String id) {
        super(id);
    }

    public AbstractRepeater(String id, IModel<?> model) {
        super(id, model);
    }

    protected abstract Iterator<? extends Component> renderIterator();

    @Override
    protected final void onRender() {
        Iterator<? extends Component> it = this.renderIterator();
        while (it.hasNext()) {
            Component child = it.next();
            if (child == null) {
                throw new IllegalStateException("The render iterator returned null for a child. Container: " + this.toString() + "; Iterator=" + it.toString());
            }
            this.renderChild(child);
        }
    }

    protected void renderChild(Component child) {
        child.render();
    }

    @Override
    protected void onBeforeRender() {
        this.onPopulate();
        if (this.getApplication().usesDevelopmentConfig()) {
            for (Component c : this) {
                Matcher matcher = SAFE_CHILD_ID_PATTERN.matcher(c.getId());
                if (matcher.matches()) continue;
                log.warn("Child component of repeater " + this.getClass().getName() + ":" + this.getId() + " has a non-safe child id of " + c.getId() + ". Safe child ids must be composed of digits only.");
                break;
            }
        }
        super.onBeforeRender();
    }

    @Override
    public IMarkupFragment getMarkup(Component child) {
        return this.getMarkup();
    }

    protected abstract void onPopulate();
}

