/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.wicket.request.resource.ClassScanner;
import org.apache.wicket.request.resource.PackageResource;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceReferenceRegistry {
    private static final Logger log = LoggerFactory.getLogger(ResourceReferenceRegistry.class);
    private ClassScanner scanner = new ClassScanner(){

        @Override
        boolean foundResourceReference(ResourceReference reference) {
            return ResourceReferenceRegistry.this.registerResourceReference(reference);
        }
    };
    private final ConcurrentHashMap<ResourceReference.Key, ResourceReference> map = Generics.newConcurrentHashMap();
    private Queue<ResourceReference.Key> autoAddedQueue;
    private int autoAddedCapacity = 1000;

    public ResourceReferenceRegistry() {
        this.setAutoAddedCapacity(this.autoAddedCapacity);
    }

    public final boolean registerResourceReference(ResourceReference reference) {
        return null != this._registerResourceReference(reference);
    }

    private ResourceReference.Key _registerResourceReference(ResourceReference reference) {
        Args.notNull((Object)reference, (String)"reference");
        if (reference.canBeRegistered()) {
            ResourceReference.Key key = reference.getKey();
            this.map.putIfAbsent(key, reference);
            return key;
        }
        log.warn("{} cannot be added to the registry.", (Object)reference.getClass().getName());
        return null;
    }

    public final ResourceReference unregisterResourceReference(ResourceReference.Key key) {
        Args.notNull((Object)key, (String)"key");
        ResourceReference removed = this.map.remove(key);
        if (this.autoAddedQueue != null) {
            this.autoAddedQueue.remove(key);
        }
        return removed;
    }

    public final ResourceReference getResourceReference(Class<?> scope, String name, Locale locale, String style, String variation, boolean strict, boolean createIfNotFound) {
        return this.getResourceReference(new ResourceReference.Key(scope.getName(), name, locale, style, variation), strict, createIfNotFound);
    }

    public final ResourceReference getResourceReference(ResourceReference.Key key, boolean strict, boolean createIfNotFound) {
        ResourceReference resource = this._getResourceReference(key.getScope(), key.getName(), key.getLocale(), key.getStyle(), key.getVariation(), strict);
        if (resource == null) {
            if (this.scanner.scanClass(key.getScopeClass()) > 0) {
                resource = this._getResourceReference(key.getScope(), key.getName(), key.getLocale(), key.getStyle(), key.getVariation(), strict);
            }
            if (resource == null && createIfNotFound) {
                resource = this.addDefaultResourceReference(key);
            }
        }
        return resource;
    }

    private ResourceReference _getResourceReference(String scope, String name, Locale locale, String style, String variation, boolean strict) {
        ResourceReference.Key key = new ResourceReference.Key(scope, name, locale, style, variation);
        ResourceReference res = this.map.get(key);
        if (res != null || strict) {
            return res;
        }
        res = this._getResourceReference(scope, name, locale, style, null, true);
        if (res == null) {
            res = this._getResourceReference(scope, name, locale, null, variation, true);
        }
        if (res == null) {
            res = this._getResourceReference(scope, name, locale, null, null, true);
        }
        if (res == null) {
            res = this._getResourceReference(scope, name, null, style, variation, true);
        }
        if (res == null) {
            res = this._getResourceReference(scope, name, null, style, null, true);
        }
        if (res == null) {
            res = this._getResourceReference(scope, name, null, null, variation, true);
        }
        if (res == null) {
            res = this._getResourceReference(scope, name, null, null, null, true);
        }
        return res;
    }

    private ResourceReference addDefaultResourceReference(ResourceReference.Key key) {
        ResourceReference reference = this.createDefaultResourceReference(key);
        if (reference != null) {
            this.enforceAutoAddedCacheSize(this.getAutoAddedCapacity());
            this._registerResourceReference(reference);
            if (this.autoAddedQueue != null) {
                this.autoAddedQueue.add(key);
            }
        } else {
            log.warn("A ResourceReference wont be created for a resource with key [{}] because it cannot be located.", (Object)key);
        }
        return reference;
    }

    private void enforceAutoAddedCacheSize(int maxSize) {
        if (this.autoAddedQueue != null) {
            while (this.autoAddedQueue.size() > maxSize) {
                ResourceReference.Key first = this.autoAddedQueue.remove();
                this.map.remove(first);
            }
        }
    }

    protected ResourceReference createDefaultResourceReference(ResourceReference.Key key) {
        if (PackageResource.exists(key.getScopeClass(), key.getName(), key.getLocale(), key.getStyle(), key.getVariation())) {
            return new PackageResourceReference(key);
        }
        return null;
    }

    public final void setAutoAddedCapacity(int autoAddedCapacity) {
        if (autoAddedCapacity < 0) {
            this.clearAutoAddedEntries();
            this.autoAddedQueue = null;
        } else {
            this.autoAddedCapacity = autoAddedCapacity;
            if (this.autoAddedQueue == null) {
                this.autoAddedQueue = new ConcurrentLinkedQueue<ResourceReference.Key>();
            } else {
                this.enforceAutoAddedCacheSize(autoAddedCapacity);
            }
        }
    }

    public final int getAutoAddedCapacity() {
        return this.autoAddedCapacity;
    }

    public final void clearAutoAddedEntries() {
        this.enforceAutoAddedCacheSize(0);
    }

    public final int getAutoAddedCacheSize() {
        return this.autoAddedQueue == null ? -1 : this.autoAddedQueue.size();
    }

    public final int getSize() {
        return this.map.size();
    }
}

