/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.bundles;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.bundles.ConcatBundleResource;
import org.apache.wicket.resource.bundles.IResourceBundle;
import org.apache.wicket.util.lang.Args;

public class ConcatResourceBundleReference<T extends HeaderItem>
extends ResourceReference
implements IResourceBundle {
    private static final long serialVersionUID = 1L;
    private final List<T> providedResources;

    public ConcatResourceBundleReference(Class<?> scope, String name, List<T> resources) {
        this(scope, name, null, null, null, resources);
    }

    public ConcatResourceBundleReference(Class<?> scope, String name, T ... resources) {
        this(scope, name, null, null, null, Arrays.asList(resources));
    }

    public ConcatResourceBundleReference(String name, T ... resources) {
        this(Application.class, name, null, null, null, Arrays.asList(resources));
    }

    public ConcatResourceBundleReference(Class<?> scope, String name, Locale locale, String style, String variation, List<T> resources) {
        super(scope, name, locale, style, variation);
        this.providedResources = (List)Args.notNull(resources, (String)"resources");
    }

    @Override
    public IResource getResource() {
        return new ConcatBundleResource(this.providedResources);
    }

    public List<T> getProvidedResources() {
        return this.providedResources;
    }

    @Override
    public Iterable<? extends HeaderItem> getDependencies() {
        LinkedHashSet<HeaderItem> ret = new LinkedHashSet<HeaderItem>();
        for (HeaderItem curProvided : this.providedResources) {
            for (HeaderItem headerItem : curProvided.getDependencies()) {
                ret.add(headerItem);
            }
        }
        for (HeaderItem curProvided : this.providedResources) {
            ret.remove(curProvided);
        }
        return ret;
    }
}

