/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.form.AbstractChoice;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.IValueMap;

public class RadioChoice<T>
extends AbstractSingleSelectChoice<T>
implements IOnChangeListener {
    private static final long serialVersionUID = 1L;
    private String prefix = "";
    private String suffix = "<br />\n";
    private AbstractChoice.LabelPosition labelPosition = AbstractChoice.LabelPosition.AFTER;

    public RadioChoice(String id) {
        super(id);
    }

    public RadioChoice(String id, List<? extends T> choices) {
        super(id, choices);
    }

    public RadioChoice(String id, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public RadioChoice(String id, IModel<T> model, List<? extends T> choices) {
        super(id, model, choices);
    }

    public RadioChoice(String id, IModel<T> model, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    public RadioChoice(String id, IModel<? extends List<? extends T>> choices) {
        super(id, choices);
    }

    public RadioChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices) {
        super(id, model, choices);
    }

    public RadioChoice(String id, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public RadioChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.remove("name");
    }

    @Override
    public void onSelectionChanged() {
        this.convertInput();
        this.updateModel();
        this.onSelectionChanged(this.getDefaultModelObject());
    }

    protected void onSelectionChanged(Object newSelection) {
    }

    protected boolean wantOnSelectionChangedNotifications() {
        return false;
    }

    @Override
    protected boolean getStatelessHint() {
        if (this.wantOnSelectionChangedNotifications()) {
            return false;
        }
        return super.getStatelessHint();
    }

    public String getPrefix() {
        return this.prefix;
    }

    protected String getPrefix(int index, T choice) {
        return this.getPrefix();
    }

    protected String getSuffix(int index, T choice) {
        return this.getSuffix();
    }

    public final RadioChoice<T> setPrefix(String prefix) {
        this.addStateChange();
        this.prefix = prefix;
        return this;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public final RadioChoice<T> setSuffix(String suffix) {
        this.addStateChange();
        this.suffix = suffix;
        return this;
    }

    public RadioChoice<T> setLabelPosition(AbstractChoice.LabelPosition labelPosition) {
        Args.notNull((Object)((Object)labelPosition), (String)"labelPosition");
        this.labelPosition = labelPosition;
        return this;
    }

    @Override
    public final void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        List choices = this.getChoices();
        AppendingStringBuffer buffer = new AppendingStringBuffer((choices.size() + 1) * 70);
        String selected = this.getValue();
        for (int index = 0; index < choices.size(); ++index) {
            Object choice = choices.get(index);
            this.appendOptionHtml(buffer, (T)choice, index, selected);
        }
        this.replaceComponentTagBody(markupStream, openTag, (CharSequence)buffer);
    }

    @Override
    protected void appendOptionHtml(AppendingStringBuffer buffer, T choice, int index, String selected) {
        Object displayValue = this.getChoiceRenderer().getDisplayValue(choice);
        Class<?> objectClass = displayValue == null ? null : displayValue.getClass();
        String label = "";
        if (objectClass != null && objectClass != String.class) {
            IConverter<?> converter = this.getConverter(objectClass);
            label = converter.convertToString(displayValue, this.getLocale());
        } else if (displayValue != null) {
            label = displayValue.toString();
        }
        if (label != null) {
            IValueMap attrs;
            buffer.append(this.getPrefix(index, choice));
            String id = this.getChoiceRenderer().getIdValue(choice, index);
            String idAttr = this.getMarkupId() + "-" + id;
            boolean enabled = this.isEnabledInHierarchy() && !this.isDisabled(choice, index, selected);
            String display = label;
            if (this.localizeDisplayValues()) {
                display = this.getLocalizer().getString(label, (Component)this, label);
            }
            CharSequence escaped = display;
            if (this.getEscapeModelStrings()) {
                escaped = Strings.escapeMarkup((CharSequence)display);
            }
            IValueMap labelAttrs = this.getAdditionalAttributesForLabel(index, choice);
            StringBuilder extraLabelAttributes = new StringBuilder();
            if (labelAttrs != null) {
                for (Map.Entry attr : labelAttrs.entrySet()) {
                    extraLabelAttributes.append(' ').append((String)attr.getKey()).append("=\"").append(attr.getValue()).append('\"');
                }
            }
            switch (this.labelPosition) {
                case BEFORE: {
                    buffer.append("<label for=\"").append(idAttr).append('\"').append(extraLabelAttributes).append('>').append((Object)escaped).append("</label>");
                    break;
                }
                case WRAP_BEFORE: {
                    buffer.append("<label").append(extraLabelAttributes).append('>').append((Object)escaped).append(' ');
                    break;
                }
                case WRAP_AFTER: {
                    buffer.append("<label").append(extraLabelAttributes).append('>');
                }
            }
            buffer.append("<input name=\"").append(this.getInputName()).append('\"').append(" type=\"radio\"").append(this.isSelected(choice, index, selected) ? " checked=\"checked\"" : "").append(enabled ? "" : " disabled=\"disabled\"").append(" value=\"").append(id).append("\" id=\"").append(idAttr).append('\"');
            if (this.wantOnSelectionChangedNotifications()) {
                CharSequence url = this.urlFor(IOnChangeListener.INTERFACE, new PageParameters());
                Form form = this.findParent(Form.class);
                if (form != null) {
                    buffer.append(" onclick=\"").append((Object)form.getJsForInterfaceUrl(url)).append(";\"");
                } else {
                    buffer.append(" onclick=\"window.location.href='").append((Object)url).append((url.toString().indexOf(63) > -1 ? (char)'&' : '?') + this.getInputName()).append('=').append(id).append("';\"");
                }
            }
            if ((attrs = this.getAdditionalAttributes(index, choice)) != null) {
                for (Map.Entry attr : attrs.entrySet()) {
                    buffer.append(' ').append((String)attr.getKey()).append("=\"").append(attr.getValue()).append('\"');
                }
            }
            if (this.getApplication().getDebugSettings().isOutputComponentPath()) {
                CharSequence path = this.getPageRelativePath();
                path = Strings.replaceAll((CharSequence)path, (CharSequence)"_", (CharSequence)"__");
                path = Strings.replaceAll((CharSequence)path, (CharSequence)":", (CharSequence)"_");
                buffer.append(" wicketpath=\"").append((Object)path).append("_input_").append(index).append('\"');
            }
            buffer.append("/>");
            switch (this.labelPosition) {
                case AFTER: {
                    buffer.append("<label for=\"").append(idAttr).append('\"').append(extraLabelAttributes).append('>').append((Object)escaped).append("</label>");
                    break;
                }
                case WRAP_BEFORE: {
                    buffer.append("</label>");
                    break;
                }
                case WRAP_AFTER: {
                    buffer.append(' ').append((Object)escaped).append("</label>");
                }
            }
            buffer.append(this.getSuffix(index, choice));
        }
    }

    protected IValueMap getAdditionalAttributesForLabel(int index, T choice) {
        return null;
    }

    protected IValueMap getAdditionalAttributes(int index, T choice) {
        return null;
    }
}

