/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.internal;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.parser.filter.EnclosureHandler;
import org.apache.wicket.markup.resolver.ComponentResolvers;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Enclosure
extends WebMarkupContainer
implements IComponentResolver {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(Enclosure.class);
    private Component childComponent;
    private final CharSequence childId;

    public Enclosure(String id, CharSequence childId) {
        super(id);
        if (childId == null) {
            throw new MarkupException("You most likely forgot to register the EnclosureHandler with the MarkupParserFactory");
        }
        this.childId = childId;
    }

    public final String getChildId() {
        return this.childId.toString();
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.childComponent = this.getChildComponent(new MarkupStream(this.getMarkup()), this.getEnclosureParent());
    }

    protected final Component getChild() {
        return this.childComponent;
    }

    @Override
    public boolean isVisible() {
        return this.childComponent.determineVisibility() && super.isVisible();
    }

    @Override
    protected void onConfigure() {
        super.onConfigure();
        Component child = this.getChild();
        child.configure();
        boolean childVisible = child.determineVisibility();
        this.setVisible(childVisible);
    }

    protected MarkupContainer getEnclosureParent() {
        MarkupContainer parent;
        for (parent = this.getParent(); parent != null && parent.isAuto(); parent = parent.getParent()) {
        }
        if (parent == null) {
            throw new WicketRuntimeException("Unable to find parent component which is not a transparent resolver");
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component getChildComponent(MarkupStream markupStream, MarkupContainer enclosureParent) {
        String fullChildId = this.getChildId();
        Component controller = enclosureParent.get(fullChildId);
        if (controller == null) {
            int orgIndex = markupStream.getCurrentIndex();
            try {
                while (markupStream.hasMore()) {
                    ComponentTag tag;
                    markupStream.next();
                    if (!markupStream.skipUntil(ComponentTag.class) || (tag = markupStream.getTag()) == null || !tag.isOpen() && !tag.isOpenClose()) continue;
                    String tagId = tag.getId();
                    if (fullChildId.equals(tagId)) {
                        ComponentTag fullComponentTag = new ComponentTag(tag);
                        fullComponentTag.setId(this.childId.toString());
                        controller = ComponentResolvers.resolve(enclosureParent, markupStream, fullComponentTag, new ComponentResolvers.ResolverFilter(){

                            @Override
                            public boolean ignoreResolver(IComponentResolver resolver) {
                                return resolver instanceof EnclosureHandler;
                            }
                        });
                        break;
                    }
                    if (!fullChildId.startsWith(tagId + ':')) continue;
                    fullChildId = Strings.afterFirst((String)fullChildId, (char)':');
                }
            }
            finally {
                markupStream.setCurrentIndex(orgIndex);
            }
        }
        this.checkChildComponent(controller);
        return controller;
    }

    @Override
    public Component resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (this.childId.equals(tag.getId())) {
            return this.childComponent;
        }
        return this.getEnclosureParent().get(tag.getId());
    }

    private void checkChildComponent(Component controller) {
        if (controller == null) {
            throw new WicketRuntimeException("Could not find child with id: " + this.childId + " in the wicket:enclosure");
        }
        if (controller == this) {
            throw new WicketRuntimeException("Programming error: childComponent == enclose component; endless loop");
        }
    }
}

