/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import org.apache.wicket.markup.parser.IXmlPullParser;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.util.io.FullyBufferedReader;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.io.XmlReader;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.parse.metapattern.parsers.TagNameParser;
import org.apache.wicket.util.parse.metapattern.parsers.VariableAssignmentParser;
import org.apache.wicket.util.string.Strings;

public final class XmlPullParser
implements IXmlPullParser {
    public static final String STYLE = "style";
    public static final String SCRIPT = "script";
    private String encoding;
    private FullyBufferedReader input;
    private String skipUntilText;
    private CharSequence lastText;
    private CharSequence doctype;
    private IXmlPullParser.HttpTagType lastType = IXmlPullParser.HttpTagType.NOT_INITIALIZED;
    private XmlTag lastTag;

    @Override
    public final String getEncoding() {
        return this.encoding;
    }

    @Override
    public final CharSequence getDoctype() {
        return this.doctype;
    }

    @Override
    public final CharSequence getInputFromPositionMarker(int toPos) {
        return this.input.getSubstring(toPos);
    }

    @Override
    public final CharSequence getInput(int fromPos, int toPos) {
        return this.input.getSubstring(fromPos, toPos);
    }

    private final void skipUntil() throws ParseException {
        int startIndex = this.input.getPosition();
        int tagNameLen = this.skipUntilText.length();
        int pos = this.input.getPosition() - 1;
        String endTagText = null;
        int lastPos = 0;
        while (!this.skipUntilText.equalsIgnoreCase(endTagText)) {
            if ((pos = this.input.find("</", pos + 1)) == -1 || pos + (tagNameLen + 2) >= this.input.size()) {
                throw new ParseException(this.skipUntilText + " tag not closed" + this.getLineAndColumnText(), startIndex);
            }
            lastPos = pos + 2;
            endTagText = this.input.getSubstring(lastPos, lastPos + tagNameLen).toString();
        }
        this.input.setPosition(pos);
        this.lastText = this.input.getSubstring(startIndex, pos);
        this.lastType = IXmlPullParser.HttpTagType.BODY;
        lastPos = this.input.find('>', lastPos + tagNameLen);
        if (lastPos == -1) {
            throw new ParseException(this.skipUntilText + " tag not closed" + this.getLineAndColumnText(), startIndex);
        }
        this.skipUntilText = null;
    }

    private String getLineAndColumnText() {
        return " (line " + this.input.getLineNumber() + ", column " + this.input.getColumnNumber() + ")";
    }

    @Override
    public final IXmlPullParser.HttpTagType next() throws ParseException {
        XmlTag tag;
        XmlTag.TextSegment text;
        XmlTag.TagType type;
        if (this.input.getPosition() >= this.input.size()) {
            return IXmlPullParser.HttpTagType.NOT_INITIALIZED;
        }
        if (this.skipUntilText != null) {
            this.skipUntil();
            return this.lastType;
        }
        int openBracketIndex = this.input.find('<');
        if (this.input.charAt(this.input.getPosition()) != '<') {
            if (openBracketIndex == -1) {
                this.lastText = this.input.getSubstring(-1);
                this.input.setPosition(this.input.size());
                this.lastType = IXmlPullParser.HttpTagType.BODY;
                return this.lastType;
            }
            this.lastText = this.input.getSubstring(openBracketIndex);
            this.input.setPosition(openBracketIndex);
            this.lastType = IXmlPullParser.HttpTagType.BODY;
            return this.lastType;
        }
        this.input.countLinesTo(openBracketIndex);
        int closeBracketIndex = -1;
        if (openBracketIndex != -1 && openBracketIndex < this.input.size() - 1) {
            char nextChar = this.input.charAt(openBracketIndex + 1);
            closeBracketIndex = nextChar == '!' || nextChar == '?' ? this.input.find('>', openBracketIndex) : this.input.findOutOfQuotes('>', openBracketIndex);
        }
        if (closeBracketIndex == -1) {
            throw new ParseException("No matching close bracket at" + this.getLineAndColumnText(), this.input.getPosition());
        }
        this.lastText = this.input.getSubstring(openBracketIndex, closeBracketIndex + 1);
        String tagText = this.lastText.subSequence(1, this.lastText.length() - 1).toString();
        if (tagText.length() == 0) {
            throw new ParseException("Found empty tag: '<>' at" + this.getLineAndColumnText(), this.input.getPosition());
        }
        if (tagText.endsWith("/")) {
            type = XmlTag.TagType.OPEN_CLOSE;
            tagText = tagText.substring(0, tagText.length() - 1);
        } else if (tagText.startsWith("/")) {
            type = XmlTag.TagType.CLOSE;
            tagText = tagText.substring(1);
        } else {
            type = XmlTag.TagType.OPEN;
            if (tagText.length() > STYLE.length() && (tagText.charAt(0) == 's' || tagText.charAt(0) == 'S')) {
                String lowerCase = tagText.toLowerCase();
                if (lowerCase.startsWith(SCRIPT)) {
                    String typeAttr = "type=";
                    int idxOfType = lowerCase.indexOf(typeAttr);
                    if (idxOfType > 0) {
                        String typePrefix = lowerCase.substring(idxOfType + typeAttr.length() + 1);
                        if (typePrefix.startsWith("text/javascript")) {
                            this.skipUntilText = SCRIPT;
                        }
                    } else {
                        this.skipUntilText = SCRIPT;
                    }
                } else if (lowerCase.startsWith(STYLE)) {
                    this.skipUntilText = STYLE;
                }
            }
        }
        char firstChar = tagText.charAt(0);
        if (firstChar == '!' || firstChar == '?') {
            this.specialTagHandling(tagText, openBracketIndex, closeBracketIndex);
            this.input.countLinesTo(openBracketIndex);
            text = new XmlTag.TextSegment(this.lastText, openBracketIndex, this.input.getLineNumber(), this.input.getColumnNumber());
            this.lastTag = new XmlTag(text, type);
            return this.lastType;
        }
        text = new XmlTag.TextSegment(this.lastText, openBracketIndex, this.input.getLineNumber(), this.input.getColumnNumber());
        this.lastTag = tag = new XmlTag(text, type);
        if (this.parseTagText(tag, tagText)) {
            this.input.setPosition(closeBracketIndex + 1);
            this.lastType = IXmlPullParser.HttpTagType.TAG;
            return this.lastType;
        }
        throw new ParseException("Malformed tag" + this.getLineAndColumnText(), openBracketIndex);
    }

    protected void specialTagHandling(String tagText, int openBracketIndex, int closeBracketIndex) throws ParseException {
        if (tagText.startsWith("!--")) {
            if (tagText.contains("![endif]--")) {
                this.lastType = IXmlPullParser.HttpTagType.CONDITIONAL_COMMENT_ENDIF;
                this.input.setPosition(closeBracketIndex + 1);
                return;
            }
            if (tagText.startsWith("!--[if ") && tagText.endsWith("]")) {
                int pos = this.input.find("]-->", openBracketIndex + 1);
                if (pos == -1) {
                    throw new ParseException("Unclosed conditional comment beginning at" + this.getLineAndColumnText(), openBracketIndex);
                }
                this.lastText = this.input.getSubstring(openBracketIndex, pos += 4);
                this.input.setPosition(closeBracketIndex + 1);
                this.lastType = IXmlPullParser.HttpTagType.CONDITIONAL_COMMENT;
            } else {
                int pos = this.input.find("-->", openBracketIndex + 1);
                if (pos == -1) {
                    throw new ParseException("Unclosed comment beginning at" + this.getLineAndColumnText(), openBracketIndex);
                }
                this.lastText = this.input.getSubstring(openBracketIndex, pos += 3);
                this.lastType = IXmlPullParser.HttpTagType.COMMENT;
                this.input.setPosition(pos);
            }
            return;
        }
        if (tagText.equals("![endif]--")) {
            this.lastType = IXmlPullParser.HttpTagType.CONDITIONAL_COMMENT_ENDIF;
            this.input.setPosition(closeBracketIndex + 1);
            return;
        }
        if (tagText.startsWith("![")) {
            String startText;
            String string = startText = tagText.length() <= 8 ? tagText : tagText.substring(0, 8);
            if (startText.toUpperCase().equals("![CDATA[")) {
                int pos1 = openBracketIndex;
                do {
                    if ((closeBracketIndex = this.findChar('>', pos1)) == -1) {
                        throw new ParseException("No matching close bracket at" + this.getLineAndColumnText(), this.input.getPosition());
                    }
                    tagText = this.input.getSubstring(openBracketIndex + 1, closeBracketIndex).toString();
                    pos1 = closeBracketIndex + 1;
                } while (!tagText.endsWith("]]"));
                this.input.setPosition(closeBracketIndex + 1);
                this.lastText = tagText;
                this.lastType = IXmlPullParser.HttpTagType.CDATA;
                return;
            }
        }
        if (tagText.charAt(0) == '?') {
            this.lastType = IXmlPullParser.HttpTagType.PROCESSING_INSTRUCTION;
            this.input.setPosition(closeBracketIndex + 1);
            return;
        }
        if (tagText.startsWith("!DOCTYPE")) {
            this.lastType = IXmlPullParser.HttpTagType.DOCTYPE;
            this.doctype = this.input.getSubstring(openBracketIndex + 1, closeBracketIndex);
            this.input.setPosition(closeBracketIndex + 1);
            return;
        }
        this.lastType = IXmlPullParser.HttpTagType.SPECIAL_TAG;
        this.input.setPosition(closeBracketIndex + 1);
    }

    @Override
    public final XmlTag getElement() {
        return this.lastTag;
    }

    @Override
    public final CharSequence getString() {
        return this.lastText;
    }

    public final XmlTag nextTag() throws ParseException {
        while (this.next() != IXmlPullParser.HttpTagType.NOT_INITIALIZED) {
            switch (this.lastType) {
                case TAG: {
                    return this.lastTag;
                }
                case BODY: {
                    break;
                }
                case COMMENT: {
                    break;
                }
                case CONDITIONAL_COMMENT: {
                    break;
                }
                case CDATA: {
                    break;
                }
                case PROCESSING_INSTRUCTION: {
                    break;
                }
            }
        }
        return null;
    }

    private int findChar(char ch, int startIndex) {
        char quote = '\u0000';
        while (startIndex < this.input.size()) {
            char charAt = this.input.charAt(startIndex);
            if (quote != '\u0000') {
                if (quote == charAt) {
                    quote = '\u0000';
                }
            } else if (charAt == '\"' || charAt == '\'') {
                quote = charAt;
            } else if (charAt == ch) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    @Override
    public void parse(CharSequence string) throws IOException {
        Args.notNull((Object)string, (String)"string");
        this.input = new FullyBufferedReader((Reader)new StringReader(string.toString()));
        this.encoding = null;
    }

    @Override
    public void parse(InputStream in) throws IOException {
        this.parse(in, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream inputStream, String encoding) throws IOException {
        Args.notNull((Object)inputStream, (String)"inputStream");
        try {
            XmlReader xmlReader = new XmlReader((InputStream)new BufferedInputStream(inputStream, 4000), encoding);
            this.input = new FullyBufferedReader((Reader)xmlReader);
            this.encoding = xmlReader.getEncoding();
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
    }

    @Override
    public final void setPositionMarker() {
        this.input.setPositionMarker(this.input.getPosition());
    }

    @Override
    public final void setPositionMarker(int pos) {
        this.input.setPositionMarker(pos);
    }

    public String toString() {
        return this.input.toString();
    }

    private boolean parseTagText(XmlTag tag, String tagText) throws ParseException {
        int tagTextLength = tagText.length();
        TagNameParser tagnameParser = new TagNameParser((CharSequence)tagText);
        if (tagnameParser.matcher().lookingAt()) {
            tag.name = tagnameParser.getName();
            tag.namespace = tagnameParser.getNamespace();
            int pos = tagnameParser.matcher().end(0);
            if (pos == tagTextLength) {
                return true;
            }
            VariableAssignmentParser attributeParser = new VariableAssignmentParser((CharSequence)tagText);
            while (attributeParser.matcher().find(pos)) {
                String value = attributeParser.getValue();
                if (value == null) {
                    value = "";
                }
                pos = attributeParser.matcher().end(0);
                if (value.startsWith("\"") || value.startsWith("'")) {
                    value = value.substring(1, value.length() - 1);
                }
                value = value.trim();
                value = Strings.unescapeMarkup((String)value).toString();
                String key = attributeParser.getKey();
                if (null != tag.getAttributes().put((Object)key, (Object)value)) {
                    throw new ParseException("Same attribute found twice: " + key + this.getLineAndColumnText(), this.input.getPosition());
                }
                if (pos != tagTextLength) continue;
                return true;
            }
            return true;
        }
        return false;
    }
}

