/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model;

import org.apache.wicket.Session;
import org.apache.wicket.model.IChainingModel;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChainingModel<T>
implements IChainingModel<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ChainingModel.class);
    private Object target;

    public ChainingModel(Object modelObject) {
        if (modelObject instanceof Session) {
            LOG.warn("It is not a good idea to reference the Session instance in models directly as it may lead to serialization problems. If you need to access a property of the session via the model use the page instance as the model object and 'session.attribute' as the path.");
        }
        this.target = modelObject;
    }

    @Override
    public void detach() {
        if (this.target instanceof IDetachable) {
            ((IDetachable)this.target).detach();
        }
    }

    @Override
    public void setObject(T object) {
        if (this.target instanceof IModel) {
            ((IModel)this.target).setObject(object);
        } else {
            this.target = object;
        }
    }

    @Override
    public T getObject() {
        if (this.target instanceof IModel) {
            return ((IModel)this.target).getObject();
        }
        return (T)this.target;
    }

    @Override
    public IModel<?> getChainedModel() {
        if (this.target instanceof IModel) {
            return (IModel)this.target;
        }
        return null;
    }

    @Override
    public void setChainedModel(IModel<?> model) {
        this.target = model;
    }

    protected final Object getTarget() {
        return this.target;
    }

    protected final ChainingModel<T> setTarget(Object modelObject) {
        this.target = modelObject;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Model:classname=[");
        sb.append(this.getClass().getName()).append(']');
        sb.append(":nestedModel=[").append(this.target).append(']');
        return sb.toString();
    }
}

