/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.AbstractRequestCycleListener;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.flow.AbortWithHttpErrorCodeException;
import org.apache.wicket.util.lang.Checks;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsrfPreventionRequestCycleListener
extends AbstractRequestCycleListener
implements IRequestCycleListener {
    private static final Logger log = LoggerFactory.getLogger(CsrfPreventionRequestCycleListener.class);
    private CsrfAction noOriginAction = CsrfAction.ALLOW;
    private CsrfAction conflictingOriginAction = CsrfAction.ABORT;
    private int errorCode = 400;
    private String errorMessage = "Origin does not correspond to request";
    private Collection<String> acceptedOrigins = new ArrayList<String>();

    public CsrfPreventionRequestCycleListener setNoOriginAction(CsrfAction action) {
        this.noOriginAction = action;
        return this;
    }

    public CsrfPreventionRequestCycleListener setConflictingOriginAction(CsrfAction action) {
        this.conflictingOriginAction = action;
        return this;
    }

    public CsrfPreventionRequestCycleListener setErrorCode(int errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public CsrfPreventionRequestCycleListener setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public CsrfPreventionRequestCycleListener addAcceptedOrigin(String acceptedOrigin) {
        int i;
        Checks.notNull((Object)"acceptedOrigin", (String)acceptedOrigin, (Object[])new Object[0]);
        int len = acceptedOrigin.length();
        for (i = 0; i < len && acceptedOrigin.charAt(i) == '.'; ++i) {
        }
        this.acceptedOrigins.add(acceptedOrigin.substring(i));
        return this;
    }

    @Override
    public void onBeginRequest(RequestCycle cycle) {
        if (log.isDebugEnabled()) {
            HttpServletRequest containerRequest = (HttpServletRequest)cycle.getRequest().getContainerRequest();
            String origin = containerRequest.getHeader("Origin");
            log.debug("Request header Origin: {}", (Object)origin);
        }
    }

    protected boolean isEnabled() {
        return true;
    }

    protected boolean isChecked(IRequestablePage targetedPage) {
        return true;
    }

    protected boolean isChecked(IRequestHandler handler) {
        return handler instanceof IPageRequestHandler && !(handler instanceof RenderPageRequestHandler);
    }

    @Override
    public void onRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler) {
        if (!this.isEnabled()) {
            log.trace("CSRF listener is disabled, no checks performed");
            return;
        }
        if (this.isChecked(handler)) {
            IPageRequestHandler prh = (IPageRequestHandler)handler;
            IRequestablePage targetedPage = prh.getPage();
            HttpServletRequest containerRequest = (HttpServletRequest)cycle.getRequest().getContainerRequest();
            String origin = containerRequest.getHeader("Origin");
            if (this.isChecked(targetedPage)) {
                this.checkOrigin(containerRequest, origin, targetedPage);
            } else {
                log.debug("Targeted page {} was opted out of the CSRF origin checks, allowed", (Object)targetedPage.getClass().getName());
                this.allowHandler(containerRequest, origin, targetedPage);
            }
        } else if (log.isTraceEnabled()) {
            log.trace("Resolved handler {} doesn't target a page, no CSRF check performed", (Object)handler.getClass().getName());
        }
    }

    private void checkOrigin(HttpServletRequest request, String origin, IRequestablePage page) {
        if (origin == null || origin.isEmpty()) {
            log.debug("Origin-header not present in request, {}", (Object)this.noOriginAction);
            switch (this.noOriginAction) {
                case ALLOW: {
                    this.allowHandler(request, origin, page);
                    break;
                }
                case SUPPRESS: {
                    this.suppressHandler(request, origin, page);
                    break;
                }
                case ABORT: {
                    this.abortHandler(request, origin, page);
                }
            }
            return;
        }
        if (this.isWhitelistedOrigin(origin = origin.toLowerCase())) {
            this.whitelistedHandler(request, origin, page);
            return;
        }
        if (!this.isLocalOrigin(request, origin)) {
            log.debug("Origin-header conflicts with request origin, {}", (Object)this.conflictingOriginAction);
            switch (this.conflictingOriginAction) {
                case ALLOW: {
                    this.allowHandler(request, origin, page);
                    break;
                }
                case SUPPRESS: {
                    this.suppressHandler(request, origin, page);
                    break;
                }
                case ABORT: {
                    this.abortHandler(request, origin, page);
                }
            }
        } else {
            this.matchingOrigin(request, origin, page);
        }
    }

    private boolean isWhitelistedOrigin(String origin) {
        try {
            URI originUri = new URI(origin);
            String originHost = originUri.getHost();
            if (Strings.isEmpty((CharSequence)originHost)) {
                return false;
            }
            for (String whitelistedOrigin : this.acceptedOrigins) {
                if (!originHost.equalsIgnoreCase(whitelistedOrigin) && !originHost.endsWith("." + whitelistedOrigin)) continue;
                log.trace("Origin {} matched whitelisted origin {}, request accepted", (Object)origin, (Object)whitelistedOrigin);
                return true;
            }
        }
        catch (URISyntaxException e) {
            log.debug("Origin: {} not parseable as an URI. Whitelisted-origin check skipped.", (Object)origin);
        }
        return false;
    }

    private boolean isLocalOrigin(HttpServletRequest containerRequest, String originHeader) {
        String origin = this.getOriginHeaderOrigin(originHeader);
        if (origin == null) {
            return false;
        }
        String request = this.getLocationHeaderOrigin(containerRequest);
        if (request == null) {
            return false;
        }
        return origin.equalsIgnoreCase(request);
    }

    private String getOriginHeaderOrigin(String origin) {
        if ("null".equals(origin)) {
            return null;
        }
        StringBuilder target = new StringBuilder();
        try {
            URI originUri = new URI(origin);
            String scheme = originUri.getScheme();
            if (scheme == null) {
                return null;
            }
            scheme = scheme.toLowerCase(Locale.ENGLISH);
            target.append(scheme);
            target.append("://");
            String host = originUri.getHost();
            if (host == null) {
                return null;
            }
            target.append(host);
            int port = originUri.getPort();
            if (port != -1 && "http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
                target.append(':');
                target.append(port);
            }
            return target.toString();
        }
        catch (URISyntaxException e) {
            log.debug("Invalid Origin header provided: {}, marked conflicting", (Object)origin);
            return null;
        }
    }

    private String getLocationHeaderOrigin(HttpServletRequest request) {
        StringBuilder target = new StringBuilder();
        String scheme = request.getScheme();
        if (scheme == null) {
            return null;
        }
        scheme = scheme.toLowerCase(Locale.ENGLISH);
        target.append(scheme);
        target.append("://");
        String host = request.getServerName();
        if (host == null) {
            return null;
        }
        target.append(host);
        int port = request.getServerPort();
        if ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
            target.append(':');
            target.append(port);
        }
        return target.toString();
    }

    private void whitelistedHandler(HttpServletRequest request, String origin, IRequestablePage page) {
        this.onWhitelisted(request, origin, page);
        if (log.isDebugEnabled()) {
            log.debug("CSRF Origin {} was whitelisted, allowed for page {}", (Object)origin, (Object)page.getClass().getName());
        }
    }

    protected void onWhitelisted(HttpServletRequest request, String origin, IRequestablePage page) {
    }

    private void matchingOrigin(HttpServletRequest request, String origin, IRequestablePage page) {
        this.onMatchingOrigin(request, origin, page);
        if (log.isDebugEnabled()) {
            log.debug("CSRF Origin {} matched requested resource, allowed for page {}", (Object)origin, (Object)page.getClass().getName());
        }
    }

    protected void onMatchingOrigin(HttpServletRequest request, String origin, IRequestablePage page) {
    }

    private void allowHandler(HttpServletRequest request, String origin, IRequestablePage page) {
        this.onAllowed(request, origin, page);
        log.info("Possible CSRF attack, request URL: {}, Origin: {}, action: allowed", (Object)request.getRequestURL(), (Object)origin);
    }

    protected void onAllowed(HttpServletRequest request, String origin, IRequestablePage page) {
    }

    private void suppressHandler(HttpServletRequest request, String origin, IRequestablePage page) {
        this.onSuppressed(request, origin, page);
        log.info("Possible CSRF attack, request URL: {}, Origin: {}, action: suppressed", (Object)request.getRequestURL(), (Object)origin);
        throw new RestartResponseException(page);
    }

    protected void onSuppressed(HttpServletRequest request, String origin, IRequestablePage page) {
    }

    private void abortHandler(HttpServletRequest request, String origin, IRequestablePage page) {
        this.onAborted(request, origin, page);
        log.info("Possible CSRF attack, request URL: {}, Origin: {}, action: aborted with error {} {}", new Object[]{request.getRequestURL(), origin, this.errorCode, this.errorMessage});
        throw new AbortWithHttpErrorCodeException(this.errorCode, this.errorMessage);
    }

    protected void onAborted(HttpServletRequest request, String origin, IRequestablePage page) {
    }

    public static enum CsrfAction {
        ABORT{

            public String toString() {
                return "aborted";
            }
        }
        ,
        SUPPRESS{

            public String toString() {
                return "suppressed";
            }
        }
        ,
        ALLOW{

            public String toString() {
                return "allowed";
            }
        };

    }
}

