/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.css.ICssCompressor;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.resource.IScopeAwareTextResourceProcessor;
import org.apache.wicket.util.image.ImageUtil;

public class CssUrlReplacer
implements IScopeAwareTextResourceProcessor,
ICssCompressor {
    private static final Pattern URL_PATTERN = Pattern.compile("url\\(['|\"]*(.*?)['|\"]*\\)");
    public static final String EMBED_BASE64 = "embedBase64";

    @Override
    public String process(String input, Class<?> scope, String name) {
        RequestCycle cycle = RequestCycle.get();
        Url cssUrl = Url.parse((CharSequence)name);
        Matcher matcher = URL_PATTERN.matcher(input);
        StringBuffer output = new StringBuffer();
        while (matcher.find()) {
            CharSequence processedUrl;
            Url imageCandidateUrl = Url.parse((CharSequence)matcher.group(1));
            boolean embedded = false;
            if (imageCandidateUrl.isFull()) {
                processedUrl = imageCandidateUrl.toString(Url.StringMode.FULL);
            } else if (imageCandidateUrl.isContextAbsolute()) {
                processedUrl = imageCandidateUrl.toString();
            } else {
                PackageResourceReference imageReference;
                Url cssUrlCopy = new Url(cssUrl);
                cssUrlCopy.resolveRelative(imageCandidateUrl);
                if (cssUrlCopy.getQueryString() != null && cssUrlCopy.getQueryString().contains(EMBED_BASE64)) {
                    embedded = true;
                    imageReference = new PackageResourceReference(scope, cssUrlCopy.toString().replace("?embedBase64", ""));
                    try {
                        processedUrl = ImageUtil.createBase64EncodedImage(imageReference, true);
                    }
                    catch (Exception e) {
                        throw new WicketRuntimeException("Error while embedding an image into the css: " + imageReference, e);
                    }
                } else {
                    imageReference = new PackageResourceReference(scope, cssUrlCopy.toString());
                    processedUrl = cycle.urlFor(imageReference, null);
                }
            }
            matcher.appendReplacement(output, embedded ? "url(" + processedUrl + ")" : "url('" + processedUrl + "')");
        }
        matcher.appendTail(output);
        return output.toString();
    }

    @Override
    public String compress(String original) {
        throw new UnsupportedOperationException(CssUrlReplacer.class.getSimpleName() + ".process() should be used instead!");
    }
}

