/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings.def;

import org.apache.wicket.Component;
import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.authentication.strategy.DefaultAuthenticationStrategy;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.core.util.crypt.KeyInSessionSunJceCryptFactory;
import org.apache.wicket.settings.ISecuritySettings;
import org.apache.wicket.util.crypt.ICryptFactory;
import org.apache.wicket.util.lang.Args;

public class SecuritySettings
implements ISecuritySettings {
    private IAuthorizationStrategy authorizationStrategy = IAuthorizationStrategy.ALLOW_ALL;
    private IAuthenticationStrategy authenticationStrategy;
    private ICryptFactory cryptFactory;
    private boolean enforceMounts = false;
    private IUnauthorizedComponentInstantiationListener unauthorizedComponentInstantiationListener = new IUnauthorizedComponentInstantiationListener(){

        @Override
        public void onUnauthorizedInstantiation(Component component) {
            throw new UnauthorizedInstantiationException(component.getClass());
        }
    };

    @Override
    public IAuthorizationStrategy getAuthorizationStrategy() {
        return this.authorizationStrategy;
    }

    @Override
    public synchronized ICryptFactory getCryptFactory() {
        if (this.cryptFactory == null) {
            this.cryptFactory = new KeyInSessionSunJceCryptFactory();
        }
        return this.cryptFactory;
    }

    @Override
    public boolean getEnforceMounts() {
        return this.enforceMounts;
    }

    @Override
    public IUnauthorizedComponentInstantiationListener getUnauthorizedComponentInstantiationListener() {
        return this.unauthorizedComponentInstantiationListener;
    }

    @Override
    public void setAuthorizationStrategy(IAuthorizationStrategy strategy) {
        Args.notNull((Object)strategy, (String)"authorization strategy");
        this.authorizationStrategy = strategy;
    }

    @Override
    public void setCryptFactory(ICryptFactory cryptFactory) {
        Args.notNull((Object)cryptFactory, (String)"Crypt factory");
        this.cryptFactory = cryptFactory;
    }

    @Override
    public void setEnforceMounts(boolean enforce) {
        this.enforceMounts = enforce;
    }

    @Override
    public void setUnauthorizedComponentInstantiationListener(IUnauthorizedComponentInstantiationListener unauthorizedComponentInstantiationListener) {
        this.unauthorizedComponentInstantiationListener = unauthorizedComponentInstantiationListener;
    }

    @Override
    public IAuthenticationStrategy getAuthenticationStrategy() {
        if (this.authenticationStrategy == null) {
            this.authenticationStrategy = new DefaultAuthenticationStrategy("LoggedIn");
        }
        return this.authenticationStrategy;
    }

    @Override
    public void setAuthenticationStrategy(IAuthenticationStrategy strategy) {
        this.authenticationStrategy = strategy;
    }
}

