/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.ValueMap;

public class MetaDataHeaderItem
extends HeaderItem {
    public static final String META_TAG = "meta";
    public static final String LINK_TAG = "link";
    private final Map<String, Object> tagAttributes;
    private final List<String> tagMinimizedAttributes;
    private final String tagName;

    public MetaDataHeaderItem(String tagName) {
        this.tagName = (String)Args.notEmpty((CharSequence)tagName, (String)"tagName");
        this.tagAttributes = new ValueMap();
        this.tagMinimizedAttributes = new ArrayList<String>();
    }

    public MetaDataHeaderItem addTagAttribute(String attributeName, Object attributeValue) {
        Args.notEmpty((CharSequence)attributeName, (String)"attributeName");
        Args.notNull((Object)attributeValue, (String)"attributeValue");
        this.tagAttributes.put(attributeName, attributeValue);
        return this;
    }

    public MetaDataHeaderItem addTagAttribute(String attributeName) {
        Args.notEmpty((CharSequence)attributeName, (String)"attributeName");
        this.tagMinimizedAttributes.add(attributeName);
        return this;
    }

    public String generateString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('<').append(this.tagName);
        for (Map.Entry<String, Object> entry : this.tagAttributes.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof IModel) {
                value = ((IModel)value).getObject();
            }
            buffer.append(' ').append(Strings.escapeMarkup((CharSequence)entry.getKey()));
            if (value == null) continue;
            buffer.append('=').append('\"').append(Strings.replaceAll((CharSequence)value.toString(), (CharSequence)"\"", (CharSequence)"\\\"")).append('\"');
        }
        for (String attrName : this.tagMinimizedAttributes) {
            buffer.append(' ').append(Strings.escapeMarkup((CharSequence)attrName));
        }
        buffer.append(" />\n");
        return buffer.toString();
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return Collections.singletonList(this.generateString());
    }

    @Override
    public void render(Response response) {
        response.write((CharSequence)this.generateString());
    }

    public static MetaDataHeaderItem forMetaTag(String name, String content) {
        return MetaDataHeaderItem.forMetaTag(Model.of(name), Model.of(content));
    }

    public static MetaDataHeaderItem forMetaTag(IModel<String> name, IModel<String> content) {
        MetaDataHeaderItem headerItem = new MetaDataHeaderItem(META_TAG);
        headerItem.addTagAttribute("name", name);
        headerItem.addTagAttribute("content", content);
        return headerItem;
    }

    public static MetaDataHeaderItem forLinkTag(String rel, String href) {
        return MetaDataHeaderItem.forLinkTag(Model.of(rel), Model.of(href));
    }

    public static MetaDataHeaderItem forLinkTag(IModel<String> rel, IModel<String> href) {
        MetaDataHeaderItem headerItem = new MetaDataHeaderItem(LINK_TAG);
        headerItem.addTagAttribute("rel", rel);
        headerItem.addTagAttribute("href", href);
        return headerItem;
    }

    public boolean equals(Object obj) {
        return obj instanceof MetaDataHeaderItem && ((MetaDataHeaderItem)obj).generateString().equals(this.generateString());
    }
}

