/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html.form;

import org.apache.wicket.ajax.AjaxChannel;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;

public abstract class AjaxButton
extends Button {
    private static final long serialVersionUID = 1L;
    private final Form<?> form;

    public AjaxButton(String id) {
        this(id, null, null);
    }

    public AjaxButton(String id, IModel<String> model) {
        this(id, model, null);
    }

    public AjaxButton(String id, Form<?> form) {
        this(id, null, form);
    }

    public AjaxButton(String id, IModel<String> model, Form<?> form) {
        super(id, model);
        this.form = form;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(this.newAjaxFormSubmitBehavior("click"));
    }

    protected AjaxFormSubmitBehavior newAjaxFormSubmitBehavior(String event) {
        return new AjaxFormSubmitBehavior(this.form, event){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSubmit(AjaxRequestTarget target) {
                AjaxButton.this.onSubmit(target, AjaxButton.this.getForm());
            }

            @Override
            protected void onAfterSubmit(AjaxRequestTarget target) {
                AjaxButton.this.onAfterSubmit(target, AjaxButton.this.getForm());
            }

            @Override
            protected void onError(AjaxRequestTarget target) {
                AjaxButton.this.onError(target, AjaxButton.this.getForm());
            }

            @Override
            protected AjaxChannel getChannel() {
                return AjaxButton.this.getChannel();
            }

            @Override
            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AjaxButton.this.updateAjaxAttributes(attributes);
            }

            @Override
            public boolean getDefaultProcessing() {
                return AjaxButton.this.getDefaultFormProcessing();
            }
        };
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    @Override
    public Form<?> getForm() {
        if (this.form != null) {
            return this.form;
        }
        return super.getForm();
    }

    @Deprecated
    protected AjaxChannel getChannel() {
        return null;
    }

    protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
    }

    protected void onAfterSubmit(AjaxRequestTarget target, Form<?> form) {
    }

    protected void onError(AjaxRequestTarget target, Form<?> form) {
    }
}

