/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Collections;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.settings.IJavaScriptLibrarySettings;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class OnEventHeaderItem
extends HeaderItem {
    private final String target;
    private final String event;
    private final CharSequence javaScript;

    public static OnEventHeaderItem forScript(String target, String event, CharSequence javaScript) {
        return new OnEventHeaderItem(target, event, javaScript);
    }

    public OnEventHeaderItem(String target, String event) {
        this(target, event, null);
    }

    public OnEventHeaderItem(String target, String event, CharSequence javaScript) {
        this.target = (String)Args.notEmpty((CharSequence)target, (String)"target");
        Args.notEmpty((CharSequence)event, (String)"event");
        event = event.toLowerCase(Locale.ENGLISH);
        if (event.startsWith("on")) {
            event = event.substring(2);
        }
        this.event = event;
        this.javaScript = javaScript;
    }

    public String getTarget() {
        return this.target;
    }

    public String getEvent() {
        return this.event;
    }

    public CharSequence getJavaScript() {
        return this.javaScript;
    }

    @Override
    public void render(Response response) {
        if (!Strings.isEmpty((CharSequence)this.getJavaScript())) {
            JavaScriptUtils.writeJavaScript(response, this.getCompleteJavaScript());
        }
    }

    public CharSequence getCompleteJavaScript() {
        StringBuilder result = new StringBuilder();
        result.append("Wicket.Event.add(").append(this.getTarget()).append(", \"").append(this.getEvent()).append("\", function(event) { ").append(this.getJavaScript()).append(";});");
        return result;
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return Collections.singletonList("javascript-event-" + this.getTarget() + "-" + this.getEvent() + "-" + this.getJavaScript());
    }

    public String toString() {
        return "OnEventHeaderItem(" + this.getTarget() + ", '" + this.getEvent() + "', '" + this.getJavaScript() + "')";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OnEventHeaderItem that = (OnEventHeaderItem)o;
        if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
            return false;
        }
        if (this.event != null ? !this.event.equals(that.event) : that.event != null) {
            return false;
        }
        return this.javaScript != null ? this.javaScript.equals(that.javaScript) : that.javaScript == null;
    }

    public int hashCode() {
        int result = this.target != null ? this.target.hashCode() : 0;
        result = 31 * result + (this.event != null ? this.event.hashCode() : 0);
        result = 31 * result + (this.javaScript != null ? this.javaScript.hashCode() : 0);
        return result;
    }

    @Override
    public Iterable<? extends HeaderItem> getDependencies() {
        IJavaScriptLibrarySettings ajaxSettings = Application.get().getJavaScriptLibrarySettings();
        ResourceReference wicketEventReference = ajaxSettings.getWicketEventReference();
        return Collections.singletonList(JavaScriptHeaderItem.forReference(wicketEventReference));
    }
}

