/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.page;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.wicket.page.AbstractPageManager;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.page.IPageManagerContext;
import org.apache.wicket.page.RequestAdapter;
import org.apache.wicket.pageStore.IPageStore;

public class PageStoreManager
extends AbstractPageManager {
    private static final ConcurrentMap<String, PageStoreManager> MANAGERS = new ConcurrentHashMap<String, PageStoreManager>();
    private static final String ATTRIBUTE_NAME = "wicket:persistentPageManagerData";
    private final IPageStore pageStore;
    private final String applicationName;

    public PageStoreManager(String applicationName, IPageStore pageStore, IPageManagerContext context) {
        super(context);
        this.applicationName = applicationName;
        this.pageStore = pageStore;
        if (MANAGERS.containsKey(applicationName)) {
            throw new IllegalStateException("Manager for application with key '" + applicationName + "' already exists.");
        }
        MANAGERS.put(applicationName, this);
    }

    private String getAttributeName() {
        return "wicket:persistentPageManagerData - " + this.applicationName;
    }

    @Override
    protected RequestAdapter newRequestAdapter(IPageManagerContext context) {
        return new PersistentRequestAdapter(context);
    }

    @Override
    public boolean supportsVersioning() {
        return true;
    }

    @Override
    public void sessionExpired(String sessionId) {
        String sessionEntryAttributeName;
        RequestAdapter requestAdapter = this.getRequestAdapter();
        Serializable sessionEntry = requestAdapter.getSessionAttribute(sessionEntryAttributeName = this.getAttributeName());
        if (sessionEntry instanceof SessionEntry) {
            ((SessionEntry)sessionEntry).valueUnbound(null);
        }
    }

    @Override
    public void destroy() {
        MANAGERS.remove(this.applicationName);
        this.pageStore.destroy();
    }

    protected class PersistentRequestAdapter
    extends RequestAdapter {
        public PersistentRequestAdapter(IPageManagerContext context) {
            super(context);
        }

        @Override
        protected IManageablePage getPage(int id) {
            IManageablePage touchedPage = this.findPage(id);
            if (touchedPage != null) {
                return touchedPage;
            }
            SessionEntry entry = this.getSessionEntry(false);
            if (entry != null) {
                return entry.getPage(id);
            }
            return null;
        }

        private SessionEntry getSessionEntry(boolean create) {
            SessionEntry entry = (SessionEntry)this.getSessionAttribute(PageStoreManager.this.getAttributeName());
            if (entry == null && create) {
                this.bind();
                entry = new SessionEntry(PageStoreManager.this.applicationName, this.getSessionId());
            }
            return entry;
        }

        @Override
        protected void newSessionCreated() {
            if (this.getSessionId() != null) {
                this.getSessionEntry(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void storeTouchedPages(List<IManageablePage> touchedPages) {
            if (!touchedPages.isEmpty()) {
                SessionEntry entry = this.getSessionEntry(true);
                entry.setSessionCache(touchedPages);
                for (IManageablePage page : touchedPages) {
                    PageStoreManager.this.pageStore.storePage(entry.sessionId, page);
                }
                entry.storingTouchedPages.set(true);
                try {
                    this.setSessionAttribute(PageStoreManager.this.getAttributeName(), entry);
                }
                finally {
                    entry.storingTouchedPages.set(false);
                }
            }
        }
    }

    private static class SessionEntry
    implements Serializable,
    HttpSessionBindingListener {
        private static final long serialVersionUID = 1L;
        private final String applicationName;
        private final String sessionId;
        private transient List<IManageablePage> sessionCache;
        private transient List<Object> afterReadObject;
        private transient ThreadLocal<Boolean> storingTouchedPages = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };

        public SessionEntry(String applicationName, String sessionId) {
            this.applicationName = applicationName;
            this.sessionId = sessionId;
        }

        private IPageStore getPageStore() {
            PageStoreManager manager = (PageStoreManager)MANAGERS.get(this.applicationName);
            if (manager == null) {
                return null;
            }
            return manager.pageStore;
        }

        private IManageablePage findPage(int id) {
            for (IManageablePage p : this.sessionCache) {
                if (p.getPageId() != id) continue;
                return p;
            }
            return null;
        }

        private void addPage(IManageablePage page) {
            if (page != null) {
                if (this.findPage(page.getPageId()) != null) {
                    return;
                }
                this.sessionCache.add(page);
            }
        }

        private void convertAfterReadObjects() {
            IPageStore pageStore;
            if (this.sessionCache == null) {
                this.sessionCache = new ArrayList<IManageablePage>();
            }
            if ((pageStore = this.getPageStore()) != null) {
                for (Object o : this.afterReadObject) {
                    IManageablePage page = pageStore.convertToPage(o);
                    this.addPage(page);
                }
            }
            this.afterReadObject = null;
        }

        public synchronized IManageablePage getPage(int id) {
            if (this.afterReadObject != null && !this.afterReadObject.isEmpty()) {
                this.convertAfterReadObjects();
            }
            IManageablePage page = null;
            if (this.sessionCache != null && (page = this.findPage(id)) != null) {
                return page;
            }
            IPageStore pageStore = this.getPageStore();
            if (pageStore != null) {
                page = pageStore.getPage(this.sessionId, id);
            }
            return page;
        }

        public synchronized void setSessionCache(List<IManageablePage> pages) {
            this.sessionCache = new ArrayList<IManageablePage>(pages);
            this.afterReadObject = null;
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
            ArrayList<Object> serializedPages = new ArrayList<Object>();
            if (this.sessionCache != null) {
                IPageStore pageStore = this.getPageStore();
                for (IManageablePage p : this.sessionCache) {
                    Object preparedPage = pageStore != null ? pageStore.prepareForSerialization(this.sessionId, p) : p;
                    if (preparedPage == null) continue;
                    serializedPages.add(preparedPage);
                }
            }
            s.writeObject(serializedPages);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.storingTouchedPages = new ThreadLocal<Boolean>(){

                @Override
                protected Boolean initialValue() {
                    return Boolean.FALSE;
                }
            };
            this.afterReadObject = new ArrayList<Object>();
            List l = (List)s.readObject();
            IPageStore pageStore = this.getPageStore();
            for (Serializable ser : l) {
                Object page = pageStore != null ? pageStore.restoreAfterSerialization(ser) : ser;
                this.afterReadObject.add(page);
            }
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            if (this.storingTouchedPages.get().booleanValue()) {
                return;
            }
            IPageStore store = this.getPageStore();
            if (store != null) {
                store.unbind(this.sessionId);
            }
        }

        public boolean equals(Object o) {
            return false;
        }
    }
}

