/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.IWrappedHeaderItem;
import org.apache.wicket.markup.head.NoHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.DecoratingHeaderResponse;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.resource.CircularDependencyException;
import org.apache.wicket.util.lang.Classes;

public class ResourceAggregator
extends DecoratingHeaderResponse {
    private final Map<HeaderItem, RecordedHeaderItem> itemsToBeRendered = new LinkedHashMap<HeaderItem, RecordedHeaderItem>();
    private final List<OnDomReadyHeaderItem> domReadyItemsToBeRendered = new ArrayList<OnDomReadyHeaderItem>();
    private final List<OnLoadHeaderItem> loadItemsToBeRendered = new ArrayList<OnLoadHeaderItem>();
    private Object renderBase;
    private int indexInRenderBase;
    private int indexInRequest;

    public ResourceAggregator(IHeaderResponse real) {
        super(real);
    }

    @Override
    public void markRendered(Object object) {
        super.markRendered(object);
        if (object instanceof Component || object instanceof Behavior) {
            this.renderBase = null;
            this.indexInRenderBase = 0;
        }
    }

    @Override
    public boolean wasRendered(Object object) {
        boolean ret = super.wasRendered(object);
        if (!ret && object instanceof Component || object instanceof Behavior) {
            this.renderBase = object;
            this.indexInRenderBase = 0;
        }
        return ret;
    }

    private void recordHeaderItem(HeaderItem item, Set<HeaderItem> depsDone) {
        this.renderDependencies(item, depsDone);
        RecordedHeaderItem recordedItem = this.itemsToBeRendered.get(item);
        if (recordedItem == null) {
            recordedItem = new RecordedHeaderItem(item);
            this.itemsToBeRendered.put(item, recordedItem);
        }
        recordedItem.addLocation(this.renderBase, this.indexInRenderBase, this.indexInRequest);
        ++this.indexInRenderBase;
        ++this.indexInRequest;
    }

    private void renderDependencies(HeaderItem item, Set<HeaderItem> depsDone) {
        for (HeaderItem headerItem : item.getDependencies()) {
            if (!depsDone.add(headerItem)) {
                throw new CircularDependencyException(depsDone, headerItem);
            }
            this.recordHeaderItem(headerItem, depsDone);
            depsDone.remove(headerItem);
        }
    }

    @Override
    public void render(HeaderItem item) {
        if (item instanceof OnDomReadyHeaderItem) {
            this.renderDependencies(item, new LinkedHashSet<HeaderItem>());
            this.domReadyItemsToBeRendered.add((OnDomReadyHeaderItem)item);
        } else if (item instanceof OnLoadHeaderItem) {
            this.renderDependencies(item, new LinkedHashSet<HeaderItem>());
            this.loadItemsToBeRendered.add((OnLoadHeaderItem)item);
        } else {
            LinkedHashSet<HeaderItem> depsDone = new LinkedHashSet<HeaderItem>();
            depsDone.add(item);
            this.recordHeaderItem(item, depsDone);
        }
    }

    @Override
    public void close() {
        this.renderHeaderItems();
        if (RequestCycle.get().find(AjaxRequestTarget.class) == null) {
            this.renderCombinedEventScripts();
        } else {
            this.renderSeperateEventScripts();
        }
        super.close();
    }

    private void renderHeaderItems() {
        ArrayList<RecordedHeaderItem> sortedItemsToBeRendered = new ArrayList<RecordedHeaderItem>(this.itemsToBeRendered.values());
        Comparator<? super RecordedHeaderItem> headerItemComparator = Application.get().getResourceSettings().getHeaderItemComparator();
        if (headerItemComparator != null) {
            Collections.sort(sortedItemsToBeRendered, headerItemComparator);
        }
        for (RecordedHeaderItem curRenderItem : sortedItemsToBeRendered) {
            this.getRealResponse().render(this.getItemToBeRendered(curRenderItem.getItem()));
        }
    }

    private void renderCombinedEventScripts() {
        HeaderItem itemToBeRendered;
        StringBuilder combinedScript = new StringBuilder();
        for (OnDomReadyHeaderItem onDomReadyHeaderItem : this.domReadyItemsToBeRendered) {
            itemToBeRendered = this.getItemToBeRendered(onDomReadyHeaderItem);
            if (itemToBeRendered == onDomReadyHeaderItem) {
                combinedScript.append('\n');
                combinedScript.append(onDomReadyHeaderItem.getJavaScript());
                combinedScript.append(';');
                continue;
            }
            this.getRealResponse().render(itemToBeRendered);
        }
        if (combinedScript.length() > 0) {
            this.getRealResponse().render(OnDomReadyHeaderItem.forScript(combinedScript.append('\n').toString()));
        }
        combinedScript.setLength(0);
        for (OnLoadHeaderItem onLoadHeaderItem : this.loadItemsToBeRendered) {
            itemToBeRendered = this.getItemToBeRendered(onLoadHeaderItem);
            if (itemToBeRendered == onLoadHeaderItem) {
                combinedScript.append('\n');
                combinedScript.append(onLoadHeaderItem.getJavaScript());
                combinedScript.append(';');
                continue;
            }
            this.getRealResponse().render(itemToBeRendered);
        }
        if (combinedScript.length() > 0) {
            this.getRealResponse().render(OnLoadHeaderItem.forScript(combinedScript.append('\n').toString()));
        }
    }

    private void renderSeperateEventScripts() {
        for (OnDomReadyHeaderItem onDomReadyHeaderItem : this.domReadyItemsToBeRendered) {
            this.getRealResponse().render(this.getItemToBeRendered(onDomReadyHeaderItem));
        }
        for (OnLoadHeaderItem onLoadHeaderItem : this.loadItemsToBeRendered) {
            this.getRealResponse().render(this.getItemToBeRendered(onLoadHeaderItem));
        }
    }

    private HeaderItem getItemToBeRendered(HeaderItem item) {
        while (item instanceof IWrappedHeaderItem) {
            item = ((IWrappedHeaderItem)((Object)item)).getWrapped();
        }
        if (this.getRealResponse().wasRendered(item)) {
            return NoHeaderItem.get();
        }
        this.getRealResponse().markRendered(item);
        HeaderItem bundle = Application.get().getResourceBundles().findBundle(item);
        if (bundle == null) {
            return item;
        }
        for (HeaderItem headerItem : bundle.getProvidedResources()) {
            this.getRealResponse().markRendered(headerItem);
        }
        return bundle;
    }

    public static class RecordedHeaderItem {
        private final HeaderItem item;
        private final List<RecordedHeaderItemLocation> locations;

        public RecordedHeaderItem(HeaderItem item) {
            this.item = item;
            this.locations = new ArrayList<RecordedHeaderItemLocation>();
        }

        public void addLocation(Object renderBase, int indexInRenderBase, int indexInRequest) {
            this.locations.add(new RecordedHeaderItemLocation(renderBase, indexInRenderBase, indexInRequest));
        }

        public HeaderItem getItem() {
            return this.item;
        }

        public List<RecordedHeaderItemLocation> getLocations() {
            return this.locations;
        }

        public String toString() {
            return this.locations + ":" + this.item;
        }
    }

    public static class RecordedHeaderItemLocation {
        private final Object renderBase;
        private final int indexInRenderBase;
        private final int indexInRequest;

        public RecordedHeaderItemLocation(Object renderBase, int indexInRenderBase, int indexInRequest) {
            this.renderBase = renderBase;
            this.indexInRenderBase = indexInRenderBase;
            this.indexInRequest = indexInRequest;
        }

        public Object getRenderBase() {
            return this.renderBase;
        }

        public int getIndexInRenderBase() {
            return this.indexInRenderBase;
        }

        public int getIndexInRequest() {
            return this.indexInRequest;
        }

        public String toString() {
            return (this.renderBase == null ? "null" : Classes.simpleName(this.renderBase.getClass())) + '@' + this.indexInRenderBase;
        }
    }
}

