/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.form;

import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.ThrottlingSettings;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.IFeedback;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class AjaxFormValidatingBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final String event;
    private final Duration throttleDelay;
    private Form<?> form;
    private boolean hasBeenRendered = false;

    public AjaxFormValidatingBehavior(String event) {
        this(event, null);
    }

    public AjaxFormValidatingBehavior(String event, Duration throttleDelay) {
        this.event = event;
        this.throttleDelay = throttleDelay;
    }

    @Override
    public void bind(Component component) {
        super.bind(component);
        if (component instanceof Form) {
            this.form = (Form)component;
        } else {
            this.form = Form.findForm(component);
            if (this.form == null) {
                throw new WicketRuntimeException(AjaxFormValidatingBehavior.class.getSimpleName() + " should be bound to a Form component or a component that is inside a form!");
            }
        }
    }

    @Override
    public void onConfigure(Component component) {
        super.onConfigure(component);
        if (!this.hasBeenRendered) {
            this.hasBeenRendered = true;
            this.form.visitChildren(FormComponent.class, new FormValidateVisitor());
        }
    }

    protected void onSubmit(AjaxRequestTarget target) {
        this.addFeedbackPanels(target);
    }

    protected void onAfterSubmit(AjaxRequestTarget target) {
    }

    protected void onError(AjaxRequestTarget target) {
        this.addFeedbackPanels(target);
    }

    protected final void addFeedbackPanels(final AjaxRequestTarget target) {
        this.form.getPage().visitChildren(IFeedback.class, new IVisitor<Component, Void>(){

            public void component(Component component, IVisit<Void> visit) {
                if (component.isVisibleInHierarchy()) {
                    target.add(component);
                } else {
                    visit.dontGoDeeper();
                }
            }
        });
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    private class FormValidateVisitor
    implements IVisitor<FormComponent, Void>,
    IClusterable {
        private FormValidateVisitor() {
        }

        public void component(final FormComponent component, IVisit<Void> visit) {
            AjaxFormSubmitBehavior behavior = new AjaxFormSubmitBehavior(AjaxFormValidatingBehavior.this.form, AjaxFormValidatingBehavior.this.event){

                @Override
                protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                    super.updateAjaxAttributes(attributes);
                    if (AjaxFormValidatingBehavior.this.throttleDelay != null) {
                        String id = "throttle-" + component.getMarkupId();
                        ThrottlingSettings throttlingSettings = new ThrottlingSettings(id, AjaxFormValidatingBehavior.this.throttleDelay);
                        attributes.setThrottlingSettings(throttlingSettings);
                    }
                    AjaxFormValidatingBehavior.this.updateAjaxAttributes(attributes);
                }

                @Override
                protected void onSubmit(AjaxRequestTarget target) {
                    super.onSubmit(target);
                    AjaxFormValidatingBehavior.this.onSubmit(target);
                }

                @Override
                protected void onAfterSubmit(AjaxRequestTarget target) {
                    super.onAfterSubmit(target);
                    AjaxFormValidatingBehavior.this.onAfterSubmit(target);
                }

                @Override
                protected void onError(AjaxRequestTarget target) {
                    super.onError(target);
                    AjaxFormValidatingBehavior.this.onError(target);
                }
            };
            component.add(behavior);
            visit.dontGoDeeper();
        }
    }
}

