/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.feedback;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.string.StringList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FeedbackMessages
implements IClusterable,
Iterable<FeedbackMessage> {
    private static final Logger log = LoggerFactory.getLogger(FeedbackMessages.class);
    private static final long serialVersionUID = 1L;
    private final List<FeedbackMessage> messages = new CopyOnWriteArrayList<FeedbackMessage>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(FeedbackMessage message) {
        log.debug("Adding feedback message '{}'", (Object)message);
        List<FeedbackMessage> list = this.messages;
        synchronized (list) {
            this.messages.add(message);
        }
    }

    public final void add(Component reporter, Serializable message, int level) {
        this.add(new FeedbackMessage(reporter, message, level));
    }

    public final void debug(Component reporter, Serializable message) {
        this.add(new FeedbackMessage(reporter, message, 100));
    }

    public final void info(Component reporter, Serializable message) {
        this.add(new FeedbackMessage(reporter, message, 200));
    }

    public final void success(Component reporter, Serializable message) {
        this.add(new FeedbackMessage(reporter, message, 250));
    }

    public final void warn(Component reporter, Serializable message) {
        this.add(new FeedbackMessage(reporter, message, 300));
    }

    public final void error(Component reporter, Serializable message) {
        this.add(new FeedbackMessage(reporter, message, 400));
    }

    public final void fatal(Component reporter, Serializable message) {
        this.add(new FeedbackMessage(reporter, message, 500));
    }

    public final int clear() {
        return this.clear(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int clear(IFeedbackMessageFilter filter) {
        if (this.messages.isEmpty()) {
            return 0;
        }
        List<FeedbackMessage> toDelete = this.messages(filter);
        for (FeedbackMessage message : toDelete) {
            message.detach();
        }
        List<FeedbackMessage> list = this.messages;
        synchronized (list) {
            int sizeBefore = this.messages.size();
            this.messages.removeAll(toDelete);
            int sizeAfter = this.messages.size();
            return sizeAfter - sizeBefore;
        }
    }

    public final boolean hasMessage(IFeedbackMessageFilter filter) {
        for (FeedbackMessage message : this.messages) {
            if (filter != null && !filter.accept(message)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasMessage(int level) {
        for (FeedbackMessage message : this.messages) {
            if (!message.isLevel(level)) continue;
            return true;
        }
        return false;
    }

    public final FeedbackMessage first() {
        return this.messages.size() > 0 ? this.messages.get(0) : null;
    }

    public final FeedbackMessage first(int level) {
        for (FeedbackMessage message : this.messages) {
            if (!message.isLevel(level)) continue;
            return message;
        }
        return null;
    }

    @Override
    public final Iterator<FeedbackMessage> iterator() {
        return this.messages.iterator();
    }

    public final List<FeedbackMessage> messages(IFeedbackMessageFilter filter) {
        if (this.messages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FeedbackMessage> list = new ArrayList<FeedbackMessage>();
        for (FeedbackMessage message : this.messages) {
            if (filter != null && !filter.accept(message)) continue;
            list.add(message);
        }
        return list;
    }

    public final boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public final int size() {
        return this.messages.size();
    }

    public final int size(IFeedbackMessageFilter filter) {
        int count = 0;
        for (FeedbackMessage message : this.messages) {
            if (filter != null && !filter.accept(message)) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        return "[feedbackMessages = " + StringList.valueOf(this.messages) + ']';
    }

    public List<FeedbackMessage> toList() {
        return Collections.unmodifiableList(this.messages);
    }

    public void detach() {
        for (FeedbackMessage message : this.messages) {
            message.detach();
        }
    }
}

