/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.List;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IReferenceHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.bundles.IResourceBundle;
import org.apache.wicket.util.string.Strings;

public class CssReferenceHeaderItem
extends CssHeaderItem
implements IReferenceHeaderItem {
    private final ResourceReference reference;
    private final String media;
    private final PageParameters pageParameters;

    public CssReferenceHeaderItem(ResourceReference reference, PageParameters pageParameters, String media, String condition) {
        super(condition);
        this.reference = reference;
        this.pageParameters = pageParameters;
        this.media = media;
    }

    @Override
    public ResourceReference getReference() {
        return this.reference;
    }

    public String getMedia() {
        return this.media;
    }

    public PageParameters getPageParameters() {
        return this.pageParameters;
    }

    @Override
    public List<HeaderItem> getDependencies() {
        return this.getReference().getDependencies();
    }

    @Override
    public Iterable<? extends HeaderItem> getProvidedResources() {
        if (this.getReference() instanceof IResourceBundle) {
            return ((IResourceBundle)((Object)this.getReference())).getProvidedResources();
        }
        return super.getProvidedResources();
    }

    @Override
    public void render(Response response) {
        this.internalRenderCSSReference(response, this.getUrl(), this.media, this.getCondition());
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return Arrays.asList("css-" + Strings.stripJSessionId((String)this.getUrl()) + "-" + this.media);
    }

    public String toString() {
        return "CSSReferenceHeaderItem(" + this.getReference() + ", " + this.getPageParameters() + ")";
    }

    private String getUrl() {
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(this.getReference(), this.getPageParameters());
        return RequestCycle.get().urlFor(handler).toString();
    }

    public int hashCode() {
        return this.getReference().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CssReferenceHeaderItem) {
            return ((CssReferenceHeaderItem)obj).getReference().equals(this.getReference());
        }
        return false;
    }
}

