/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class MarkupUtil {
    public static boolean isMarkupHtml5Compliant(MarkupContainer container) {
        Args.notNull((Object)container, (String)"container");
        Page page = container.getPage();
        if (page == null) {
            throw new WicketRuntimeException("Component not attached to Page. Component: " + container.toString());
        }
        final boolean[] rtn = new boolean[]{true};
        page.visitChildren(MarkupContainer.class, new IVisitor<MarkupContainer, Void>(){

            public void component(MarkupContainer comp, IVisit<Void> visit) {
                MarkupResourceStream rs;
                Markup associatedMarkup = comp.getAssociatedMarkup();
                if (associatedMarkup != null && !(rs = associatedMarkup.getMarkupResourceStream()).isHtml5()) {
                    rtn[0] = false;
                    visit.stop();
                }
            }
        });
        return rtn[0];
    }

    public static IMarkupFragment findStartTag(IMarkupFragment markup, String tagName) {
        MarkupStream stream = new MarkupStream(markup);
        while (stream.skipUntil(WicketTag.class)) {
            ComponentTag tag = stream.getTag();
            if (tag.isOpen() || tag.isOpenClose()) {
                WicketTag wtag = (WicketTag)tag;
                if (tagName.equalsIgnoreCase(wtag.getName())) {
                    return stream.getMarkupFragment();
                }
                stream.skipToMatchingCloseTag(tag);
            }
            stream.next();
        }
        return null;
    }
}

