/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.mock;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.mock.MockRequestParameters;
import org.apache.wicket.protocol.http.mock.Cookies;
import org.apache.wicket.protocol.http.mock.MockHttpSession;
import org.apache.wicket.request.Url;
import org.apache.wicket.util.encoding.UrlDecoder;
import org.apache.wicket.util.encoding.UrlEncoder;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockHttpServletRequest
implements HttpServletRequest {
    private static final Logger log = LoggerFactory.getLogger(MockHttpServletRequest.class);
    private final Application application;
    private final ValueMap attributes = new ValueMap();
    private String authType;
    private String characterEncoding = "UTF-8";
    private final ServletContext context;
    private final Map<Cookies.Key, Cookie> cookies = new LinkedHashMap<Cookies.Key, Cookie>();
    private final ValueMap headers = new ValueMap();
    private String method;
    private final LinkedHashMap<String, String[]> parameters = new LinkedHashMap();
    private String path;
    private final HttpSession session;
    private String url;
    private Map<String, List<UploadedFile>> uploadedFiles;
    private boolean useMultiPartContentType;
    private boolean secure = false;
    private String remoteAddr = "127.0.0.1";
    private String scheme = "http";
    private String serverName = "localhost";
    private int serverPort = 80;
    private static final String crlf = "\r\n";
    private static final String boundary = "--abcdefgABCDEFG";
    private final MockRequestParameters post = new MockRequestParameters();

    public MockHttpServletRequest(Application application, HttpSession session, ServletContext context) {
        this.application = application;
        this.session = session;
        this.context = context;
        this.initialize();
    }

    public void addCookie(Cookie cookie) {
        this.cookies.put(Cookies.keyOf(cookie), cookie);
    }

    public void addCookies(Iterable<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            this.addCookie(cookie);
        }
    }

    public void addFile(String fieldName, File file, String contentType) {
        Args.notNull((Object)file, (String)"file");
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exists. You must provide an existing file: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("You can only add a File, which is not a directory. Only files can be uploaded.");
        }
        if (this.uploadedFiles == null) {
            this.uploadedFiles = new HashMap<String, List<UploadedFile>>();
        }
        UploadedFile uf = new UploadedFile(fieldName, file, contentType);
        List<UploadedFile> filesPerField = this.uploadedFiles.get(fieldName);
        if (filesPerField == null) {
            filesPerField = new ArrayList<UploadedFile>();
            this.uploadedFiles.put(fieldName, filesPerField);
        }
        filesPerField.add(uf);
        this.setUseMultiPartContentType(true);
    }

    public void addHeader(String name, String value) {
        ArrayList<String> list = (ArrayList<String>)this.headers.get((Object)name);
        if (list == null) {
            list = new ArrayList<String>(1);
            this.headers.put(name, list);
        }
        list.add(value);
    }

    public void setHeader(String name, String value) {
        ArrayList<String> list = (ArrayList<String>)this.headers.get((Object)name);
        if (list == null) {
            list = new ArrayList<String>(1);
            this.headers.put(name, list);
        }
        list.clear();
        list.add(value);
    }

    public void addDateHeader(String name, long date) {
        DateFormat df = DateFormat.getDateInstance(0);
        String dateString = df.format(new Date(date));
        this.addHeader(name, dateString);
    }

    public Object getAttribute(String name) {
        return this.attributes.get((Object)name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public Charset getCharset() {
        return Charset.forName(this.characterEncoding);
    }

    public void setUseMultiPartContentType(boolean useMultiPartContentType) {
        this.useMultiPartContentType = useMultiPartContentType;
    }

    public int getContentLength() {
        if (this.useMultiPartContentType) {
            byte[] request = this.buildRequest();
            return request.length;
        }
        return -1;
    }

    public String getContentType() {
        if (this.useMultiPartContentType) {
            return "multipart/form-data; boundary=abcdefgABCDEFG";
        }
        return null;
    }

    public String getContextPath() {
        return "/context";
    }

    public Cookie getCookie(String name) {
        Cookie[] cookies = this.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(name)) continue;
            return Cookies.copyOf(cookie);
        }
        return null;
    }

    public Cookie[] getCookies() {
        if (this.cookies.isEmpty()) {
            return null;
        }
        ArrayList<Cookie> cookieValues = new ArrayList<Cookie>();
        cookieValues.addAll(this.cookies.values());
        return cookieValues.toArray(new Cookie[cookieValues.size()]);
    }

    public long getDateHeader(String name) throws IllegalArgumentException {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        DateFormat df = DateFormat.getDateInstance(0);
        try {
            return df.parse(value).getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Can't convert header to date " + name + ": " + value);
        }
    }

    public String getHeader(String name) {
        List l = (List)this.headers.get((Object)name);
        if (l == null || l.size() < 1) {
            return null;
        }
        return (String)l.get(0);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public Enumeration<String> getHeaders(String name) {
        ArrayList list = (ArrayList)this.headers.get((Object)name);
        if (list == null) {
            list = new ArrayList();
        }
        return Collections.enumeration(list);
    }

    public ServletInputStream getInputStream() throws IOException {
        byte[] request = this.buildRequest();
        final ByteArrayInputStream bais = new ByteArrayInputStream(request);
        return new ServletInputStream(){

            public int read() {
                return bais.read();
            }
        };
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.valueOf(value);
    }

    public Locale getLocale() {
        return this.getLocales().nextElement();
    }

    private Locale getLocale(String value) {
        String[] bits = Strings.split((String)value, (char)'-');
        if (bits.length < 1) {
            return null;
        }
        String language = bits[0].toLowerCase();
        if (bits.length > 1) {
            String country = bits[1].toUpperCase();
            return new Locale(language, country);
        }
        return new Locale(language);
    }

    public Enumeration<Locale> getLocales() {
        ArrayList<Locale> list = new ArrayList<Locale>();
        String header = this.getHeader("Accept-Language");
        if (header != null) {
            String[] locales;
            for (String value : locales = Strings.split((String)header, (char)',')) {
                Locale locale = this.getLocale(value);
                if (locale == null) continue;
                list.add(locale);
            }
        }
        if (list.size() == 0) {
            list.add(Locale.getDefault());
        }
        return Collections.enumeration(list);
    }

    public String getMethod() {
        return this.method;
    }

    public String getParameter(String name) {
        String[] param = this.getParameterMap().get(name);
        if (param == null) {
            return null;
        }
        return param[0];
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> params = new HashMap<String, String[]>(this.parameters);
        for (String name : this.post.getParameterNames()) {
            List<StringValue> values = this.post.getParameterValues(name);
            for (StringValue value : values) {
                String[] present = (String[])params.get(name);
                if (present == null) {
                    params.put(name, new String[]{value.toString()});
                    continue;
                }
                String[] newval = new String[present.length + 1];
                System.arraycopy(present, 0, newval, 0, present.length);
                newval[newval.length - 1] = value.toString();
                params.put(name, newval);
            }
        }
        return params;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        String[] value = this.getParameterMap().get(name);
        if (value == null) {
            return new String[0];
        }
        if (value instanceof String[]) {
            return value;
        }
        String[] result = new String[]{value.toString()};
        return result;
    }

    public String getPathInfo() {
        return this.path;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public String getQueryString() {
        if (this.parameters.size() == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        Iterator<String> iterator = this.parameters.keySet().iterator();
        while (iterator.hasNext()) {
            String name = iterator.next();
            String[] values = this.getParameterValues(name);
            for (int i = 0; i < values.length; ++i) {
                if (name != null) {
                    buf.append(UrlEncoder.QUERY_INSTANCE.encode(name, this.getCharset()));
                }
                buf.append('=');
                if (values[i] != null) {
                    buf.append(UrlEncoder.QUERY_INSTANCE.encode(values[i], this.getCharset()));
                }
                if (i + 1 >= values.length) continue;
                buf.append('&');
            }
            if (!iterator.hasNext()) continue;
            buf.append('&');
        }
        return buf.toString();
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    @Deprecated
    public String getRealPath(String name) {
        return this.context.getRealPath(name);
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String addr) {
        this.remoteAddr = addr;
    }

    public String getRemoteHost() {
        return "localhost";
    }

    public String getRemoteUser() {
        return this.getHeader("REMOTE_USER");
    }

    public RequestDispatcher getRequestDispatcher(String name) {
        return this.context.getRequestDispatcher(name);
    }

    public String getRequestedSessionId() {
        if (this.session instanceof MockHttpSession && ((MockHttpSession)this.session).isTemporary()) {
            return null;
        }
        return this.session.getId();
    }

    public String getRequestURI() {
        if (this.url == null) {
            return this.getContextPath() + this.getServletPath();
        }
        int index = this.url.indexOf("?");
        if (index != -1) {
            return this.url.substring(0, index);
        }
        return this.url;
    }

    public StringBuffer getRequestURL() {
        StringBuffer buf = new StringBuffer();
        buf.append("http://localhost");
        buf.append(this.getContextPath());
        if (this.getPathInfo() != null) {
            buf.append(this.getPathInfo());
        }
        return buf;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
        this.secure = "https".equalsIgnoreCase(scheme);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int port) {
        this.serverPort = port;
    }

    public String getServletPath() {
        return "/servlet";
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean b) {
        HttpSession sess = null;
        if (this.session instanceof MockHttpSession) {
            MockHttpSession mockHttpSession = (MockHttpSession)this.session;
            if (b) {
                mockHttpSession.setTemporary(false);
            }
            if (!mockHttpSession.isTemporary()) {
                sess = this.session;
            }
        }
        return sess;
    }

    public Principal getUserPrincipal() {
        final String user = this.getRemoteUser();
        if (user == null) {
            return null;
        }
        return new Principal(){

            @Override
            public String getName() {
                return user;
            }
        };
    }

    public boolean hasUploadedFiles() {
        return this.uploadedFiles != null;
    }

    public void initialize() {
        this.authType = null;
        this.method = "post";
        this.cookies.clear();
        this.setDefaultHeaders();
        this.path = null;
        this.url = null;
        this.characterEncoding = "UTF-8";
        this.parameters.clear();
        this.attributes.clear();
        this.post.reset();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    public void login(String username, String password) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return null;
    }

    public Part getPart(String name) throws IOException, ServletException {
        return null;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return true;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isUserInRole(String name) {
        return false;
    }

    public void removeAttribute(String name) {
        this.attributes.remove((Object)name);
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.characterEncoding = encoding;
    }

    public void setCookies(Cookie[] theCookies) {
        this.cookies.clear();
        this.addCookies(Arrays.asList(theCookies));
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setParameter(String name, String value) {
        if (value == null) {
            this.parameters.remove(name);
        } else {
            this.parameters.put(name, new String[]{value});
        }
    }

    public void addParameter(String name, String value) {
        if (value == null) {
            return;
        }
        String[] val = this.parameters.get(name);
        if (val == null) {
            this.parameters.put(name, new String[]{value});
        } else {
            String[] newval = new String[val.length + 1];
            System.arraycopy(val, 0, newval, 0, val.length);
            newval[val.length] = value;
            this.parameters.put(name, newval);
        }
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters.putAll(parameters);
    }

    public void setPath(String path) {
        this.path = UrlDecoder.PATH_INSTANCE.decode(path, this.getCharset());
    }

    public void setURL(String url) {
        this.setUrl(Url.parse((CharSequence)url));
    }

    private void setDefaultHeaders() {
        this.headers.clear();
        this.addHeader("Accept", "text/xml,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
        this.addHeader("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
        Locale l = Locale.getDefault();
        this.addHeader("Accept-Language", l.getLanguage().toLowerCase() + "-" + l.getCountry().toLowerCase() + "," + l.getLanguage().toLowerCase() + ";q=0.5");
        this.addHeader("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US; rv:1.7) Gecko/20040707 Firefox/0.9.2");
    }

    private void newAttachment(OutputStream out) throws IOException {
        out.write(boundary.getBytes());
        out.write(crlf.getBytes());
        out.write("Content-Disposition: form-data".getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] buildRequest() {
        if (this.uploadedFiles == null && !this.useMultiPartContentType) {
            if (this.post.getParameterNames().size() == 0) {
                return "".getBytes();
            }
            Url url = new Url();
            for (String parameterName : this.post.getParameterNames()) {
                List<StringValue> values = this.post.getParameterValues(parameterName);
                for (StringValue value : values) {
                    url.addQueryParameter(parameterName, (Object)value.toString());
                }
            }
            String body = url.toString().substring(1);
            return body.getBytes();
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (String parameterName : this.post.getParameterNames()) {
                List<StringValue> values = this.post.getParameterValues(parameterName);
                for (StringValue value : values) {
                    this.newAttachment(out);
                    out.write("; name=\"".getBytes());
                    out.write(parameterName.getBytes());
                    out.write("\"".getBytes());
                    out.write(crlf.getBytes());
                    out.write(crlf.getBytes());
                    out.write(value.toString().getBytes());
                    out.write(crlf.getBytes());
                }
            }
            if (this.uploadedFiles != null) {
                for (String fieldName : this.uploadedFiles.keySet()) {
                    List<UploadedFile> files = this.uploadedFiles.get(fieldName);
                    for (UploadedFile uf : files) {
                        this.newAttachment(out);
                        out.write("; name=\"".getBytes());
                        out.write(fieldName.getBytes());
                        out.write("\"; filename=\"".getBytes());
                        out.write(uf.getFile().getName().getBytes());
                        out.write("\"".getBytes());
                        out.write(crlf.getBytes());
                        out.write("Content-Type: ".getBytes());
                        out.write(uf.getContentType().getBytes());
                        out.write(crlf.getBytes());
                        out.write(crlf.getBytes());
                        try (FileInputStream fis = new FileInputStream((java.io.File)uf.getFile());){
                            IOUtils.copy((InputStream)fis, (OutputStream)out);
                        }
                        out.write(crlf.getBytes());
                    }
                }
            }
            out.write(boundary.getBytes());
            out.write("--".getBytes());
            out.write(crlf.getBytes());
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new WicketRuntimeException(e);
        }
    }

    public String getLocalAddr() {
        return "127.0.0.1";
    }

    public String getLocalName() {
        return "127.0.0.1";
    }

    public int getLocalPort() {
        return 80;
    }

    public int getRemotePort() {
        return 80;
    }

    public void setUrl(Url url) {
        String path;
        if (url.getProtocol() != null) {
            this.setScheme(url.getProtocol());
        }
        if (url.getHost() != null) {
            this.serverName = url.getHost();
        }
        if (url.getPort() != null) {
            this.serverPort = url.getPort();
        }
        if (!(path = url.getPath(this.getCharset())).startsWith("/")) {
            path = this.getContextPath() + this.getServletPath() + '/' + path;
        }
        this.url = path;
        if (path.startsWith(this.getContextPath())) {
            path = path.substring(this.getContextPath().length());
        }
        if (path.startsWith(this.getServletPath())) {
            path = path.substring(this.getServletPath().length());
        }
        this.setPath(path);
        for (Url.QueryParameter parameter : url.getQueryParameters()) {
            this.addParameter(parameter.getName(), parameter.getValue());
        }
    }

    public Url getUrl() {
        String queryString = this.getQueryString();
        String urlString = Strings.isEmpty((CharSequence)queryString) ? this.getRequestURI() : this.getRequestURI() + '?' + queryString;
        Url url = Url.parse((CharSequence)urlString, (Charset)this.getCharset());
        url.setProtocol(this.scheme);
        url.setHost(this.serverName);
        url.setPort(Integer.valueOf(this.serverPort));
        return url;
    }

    public MockRequestParameters getPostParameters() {
        return this.post;
    }

    public String getFilterPrefix() {
        return this.getServletPath().substring(1);
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    private static class UploadedFile {
        private String fieldName;
        private File file;
        private String contentType;

        public UploadedFile(String fieldName, File file, String contentType) {
            this.fieldName = fieldName;
            this.file = file;
            this.contentType = contentType;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }
    }
}

